% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ncpen_cpp_wrap.R
\name{control.ncpen}
\alias{control.ncpen}
\title{control.ncpen: do preliminary works for \code{ncpen}.}
\usage{
control.ncpen(y.vec, x.mat, family = c("gaussian", "binomial", "poisson",
  "multinomial", "cox"), penalty = c("scad", "mcp", "tlp", "lasso",
  "classo", "ridge", "sridge", "mbridge", "mlog"), x.standardize = TRUE,
  intercept = TRUE, lambda = NULL, n.lambda = NULL,
  r.lambda = NULL, w.lambda = NULL, gamma = NULL, tau = NULL,
  alpha = NULL, aiter.max = 100, b.eps = 1e-07)
}
\arguments{
\item{y.vec}{(numeric vector) response vector.
Must be 0,1 for \code{binomial} and 1,2,..., for \code{multinomial}.}

\item{x.mat}{(numeric matrix) design matrix without intercept.
The censoring indicator must be included at the last column of the design matrix for \code{cox}.}

\item{family}{(character) regression model. Supported models are
\code{gaussian},
\code{binomial},
\code{poisson},
\code{multinomial},
and \code{cox}.
Default is \code{gaussian}.}

\item{penalty}{(character) penalty function.
Supported penalties are
\code{scad} (smoothly clipped absolute deviation),
\code{mcp} (minimax concave penalty),
\code{tlp} (truncated LASSO penalty),
\code{lasso} (least absolute shrinkage and selection operator),
\code{classo} (clipped lasso = mcp + lasso),
\code{ridge} (ridge),
\code{sridge} (sparse ridge = mcp + ridge),
\code{mbridge} (modified bridge) and
\code{mlog} (modified log).
Default is \code{scad}.}

\item{x.standardize}{(logical) whether to standardize \code{x.mat} prior to fitting the model (see details).
The estimated coefficients are always restored to the original scale.}

\item{intercept}{(logical) whether to include an intercept in the model.}

\item{lambda}{(numeric vector) user-specified sequence of \code{lambda} values.
Default is supplied automatically from samples.}

\item{n.lambda}{(numeric) the number of \code{lambda} values.
Default is 100.}

\item{r.lambda}{(numeric) ratio of the smallest \code{lambda} value to largest.
Default is 0.001 when n>p, and 0.01 for other cases.}

\item{w.lambda}{(numeric vector) penalty weights for each coefficient (see references).
If a penalty weight is set to 0, the corresponding coefficient is always nonzero.}

\item{gamma}{(numeric) additional tuning parameter for controlling shrinkage effect of \code{classo} and \code{sridge} (see references).
Default is half of the smallest \code{lambda}.}

\item{tau}{(numeric) concavity parameter of the penalties (see reference).
Default is 3.7 for \code{scad}, 2.1 for \code{mcp}, \code{classo} and \code{sridge}, 0.001 for \code{tlp}, \code{mbridge} and \code{mlog}.}

\item{alpha}{(numeric) ridge effect (weight between the penalty and ridge penalty) (see details).
Default value is 1. If penalty is \code{ridge} and \code{sridge} then \code{alpha} is set to 0.}

\item{aiter.max}{(numeric) maximum number of iterations in CD algorithm.}

\item{b.eps}{(numeric) convergence threshold for coefficients vector.}
}
\value{
An object with S3 class \code{ncpen}.
  \item{y.vec}{response vector.}
  \item{x.mat}{design matrix adjusted to supplied options such as family and intercept.}
  \item{family}{regression model.}
  \item{penalty}{penalty.}
  \item{x.standardize}{whether to standardize \code{x.mat}.}
  \item{intercept}{whether to include the intercept.}
  \item{std}{scale factor for \code{x.standardize}.}
  \item{lambda}{lambda values for the analysis.}
  \item{n.lambda}{the number of \code{lambda} values.}
  \item{r.lambda}{ratio of the smallest \code{lambda} value to largest.}
  \item{w.lambda}{penalty weights for each coefficient.}
  \item{gamma}{additional tuning parameter for controlling shrinkage effect of \code{classo} and \code{sridge} (see references).}
  \item{tau}{concavity parameter of the penalties (see references).}
  \item{alpha}{ridge effect (amount of ridge penalty). see details.}
}
\description{
The function returns controlled samples and tuning parameters for \code{ncpen} by eliminating unnecessary errors.
}
\details{
The function is used internal purpose but useful when users want to extract proper tuning parameters for \code{ncpen}.
Do not supply the samples from \code{control.ncpen} into \code{ncpen} or \code{cv.ncpen} directly to avoid unexpected errors.
}
\examples{
### linear regression with scad penalty
sam =  sam.gen.ncpen(n=200,p=10,q=5,cf.min=0.5,cf.max=1,corr=0.5)
x.mat = sam$x.mat; y.vec = sam$y.vec
tun = control.ncpen(y.vec=y.vec,x.mat=x.mat,n.lambda=10,tau=1)
tun$tau
### multinomial regression with sridge penalty
sam =  sam.gen.ncpen(n=200,p=10,q=5,k=3,cf.min=0.5,cf.max=1,corr=0.5,family="multinomial")
x.mat = sam$x.mat; y.vec = sam$y.vec
tun = control.ncpen(y.vec=y.vec,x.mat=x.mat,n.lambda=10,
                    family="multinomial",penalty="sridge",gamma=10)
### cox regression with mcp penalty
sam =  sam.gen.ncpen(n=200,p=10,q=5,r=0.2,cf.min=0.5,cf.max=1,corr=0.5,family="cox")
x.mat = sam$x.mat; y.vec = sam$y.vec
tun = control.ncpen(y.vec=y.vec,x.mat=x.mat,n.lambda=10,family="cox",penalty="scad")
}
\references{
Fan, J. and Li, R. (2001). Variable selection via nonconcave penalized likelihood and its oracle properties.
\emph{Journal of the American statistical Association}, 96, 1348-60.
Zhang, C.H. (2010). Nearly unbiased variable selection under minimax concave penalty.
\emph{The Annals of statistics}, 38(2), 894-942.
Shen, X., Pan, W., Zhu, Y. and Zhou, H. (2013). On constrained and regularized high-dimensional regression.
\emph{Annals of the Institute of Statistical Mathematics}, 65(5), 807-832.
Kwon, S., Lee, S. and Kim, Y. (2016). Moderately clipped LASSO.
\emph{Computational Statistics and Data Analysis}, 92C, 53-67.
Kwon, S. Kim, Y. and Choi, H.(2013). Sparse bridge estimation with a diverging number of parameters.
\emph{Statistics and Its Interface}, 6, 231-242.
Huang, J., Horowitz, J.L. and Ma, S. (2008). Asymptotic properties of bridge estimators in sparse high-dimensional regression models.
\emph{The Annals of Statistics}, 36(2), 587-613.
Zou, H. and Li, R. (2008). One-step sparse estimates in nonconcave penalized likelihood models.
\emph{Annals of statistics}, 36(4), 1509.
Lee, S., Kwon, S. and Kim, Y. (2016). A modified local quadratic approximation algorithm for penalized optimization problems.
\emph{Computational Statistics and Data Analysis}, 94, 275-286.
}
\seealso{
\code{\link{ncpen}}, \code{\link{cv.ncpen}}
}
\author{
Dongshin Kim, Sunghoon Kwon, Sangin Lee
}
