% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/airway_01.R
\name{airway_01}
\alias{airway_01}
\title{Airway-01 Calculation}
\usage{
airway_01(
  df = NULL,
  patient_scene_table = NULL,
  response_table = NULL,
  arrest_table = NULL,
  procedures_table = NULL,
  vitals_table = NULL,
  erecord_01_col,
  incident_date_col = NULL,
  patient_DOB_col = NULL,
  epatient_15_col,
  epatient_16_col,
  earrest_01_col,
  eresponse_05_col,
  evitals_01_col,
  evitals_06_col,
  evitals_12_col,
  eprocedures_01_col,
  eprocedures_02_col,
  eprocedures_03_col,
  eprocedures_05_col,
  eprocedures_06_col,
  confidence_interval = FALSE,
  method = c("wilson", "clopper-pearson"),
  conf.level = 0.95,
  correct = TRUE,
  ...
)
}
\arguments{
\item{df}{A dataframe or tibble containing EMS data where each row represents
an observation and columns represent features.}

\item{patient_scene_table}{A data.frame or tibble containing at least
epatient, escene, and earrest.01 fields as a fact table.}

\item{response_table}{A data.frame or tibble containing at least the
eresponse fields needed for this measure's calculations.}

\item{arrest_table}{A data.frame or tibble containing at least the earrest
fields needed for this measure's calculations.}

\item{procedures_table}{A dataframe or tibble containing at least the
eProcedures fields needed.}

\item{vitals_table}{A dataframe or tibble containing at least the eVitals
fields needed.}

\item{erecord_01_col}{The column representing the EMS record unique
identifier.}

\item{incident_date_col}{Column that contains the incident date. This
defaults to \code{NULL} as it is optional in case not available due to PII
restrictions.}

\item{patient_DOB_col}{Column that contains the patient's date of birth. This
defaults to \code{NULL} as it is optional in case not available due to PII
restrictions.}

\item{epatient_15_col}{Column representing the patient's numeric age agnostic
of unit.}

\item{epatient_16_col}{Column representing the patient's age unit ("Years",
"Months", "Days", "Hours", or "Minutes").}

\item{earrest_01_col}{Column representing whether or not the patient is in
arrest.}

\item{eresponse_05_col}{Column that contains eResponse.05.}

\item{evitals_01_col}{Date-time or POSIXct column containing vital signs
date/time}

\item{evitals_06_col}{Numeric column containing systolic blood pressure
values}

\item{evitals_12_col}{Numeric column containing pulse oximetry values.}

\item{eprocedures_01_col}{Date-time or POSIXct column for procedures}

\item{eprocedures_02_col}{Column name for whether or not the procedure was
performed prior to EMS care being provided.}

\item{eprocedures_03_col}{Column containing procedure codes with or without
procedure names.}

\item{eprocedures_05_col}{Column containing a count for how many times
procedure was attempted.}

\item{eprocedures_06_col}{Column indicating whether or not procedure was
successful.}

\item{confidence_interval}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}} Logical. If
\code{TRUE}, the function calculates a confidence interval for the proportion
estimate.}

\item{method}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}Character. Specifies the
method used to calculate confidence intervals. Options are \code{"wilson"}
(Wilson score interval) and \code{"clopper-pearson"} (exact binomial interval).
Partial matching is supported, so \code{"w"} and \code{"c"} can be used as shorthand.}

\item{conf.level}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}Numeric. The confidence
level for the interval, expressed as a proportion (e.g., 0.95 for a 95\%
confidence interval). Defaults to 0.95.}

\item{correct}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}Logical. If \code{TRUE},
applies a continuity correction to the Wilson score interval when \code{method = "wilson"}. Defaults to \code{TRUE}.}

\item{...}{optional additional arguments to pass onto \code{dplyr::summarize}.}
}
\value{
A data.frame summarizing results for two population groups (Adults
and Peds) with the following columns:
\itemize{
\item \code{pop}: Population type (Adults and Peds).
\item \code{numerator}: Count of incidents meeting the measure.
\item \code{denominator}: Total count of included incidents.
\item \code{prop}: Proportion of incidents meeting the measure.
\item \code{prop_label}: Proportion formatted as a percentage with a specified number
of decimal places.
\item \code{lower_ci}: Lower bound of the confidence interval for \code{prop}
(if \code{confidence_interval = TRUE}).
\item \code{upper_ci}: Upper bound of the confidence interval for \code{prop}
(if \code{confidence_interval = TRUE}).
}
}
\description{
Calculates the NEMSQA Airway-01 measure.

Calculates the proportion of times when the first endotracheal intubation
attempt is successful with no peri-intubation hypoxia or hypotension.
}
\examples{

# If you are sourcing your data from a SQL database connection
# or if you have your data in several different tables,
# you can pass table inputs versus a single data.frame or tibble

# create tables to test correct functioning

  # patient table
  patient_table <- tibble::tibble(

    erecord_01 = rep(c("R1", "R2", "R3", "R4", "R5"), 2),
    incident_date = rep(as.Date(c("2025-01-01", "2025-01-05", "2025-02-01",
    "2025-01-01", "2025-06-01")), 2),
    patient_dob = rep(as.Date(c("2000-01-01", "2020-01-01", "2023-02-01",
                                "2023-01-01", "1970-06-01")), 2),
    epatient_15 = rep(c(25, 5, 2, 2, 55), 2),  # Ages
    epatient_16 = rep(c("Years", "Years", "Years", "Years", "Years"), 2)

  )

  # response table
  response_table <- tibble::tibble(

    erecord_01 = rep(c("R1", "R2", "R3", "R4", "R5"), 2),
    eresponse_05 = rep(2205001, 10)

  )

  # vitals table
  vitals_table <- tibble::tibble(

    erecord_01 = rep(c("R1", "R2", "R3", "R4", "R5"), 2),
    evitals_01 = lubridate::as_datetime(c("2025-01-01 22:59:00",
    "2025-01-05 11:58:00", "2025-02-01 18:57:00", "2025-01-01 04:58:00",
    "2025-06-01 12:57:00", "2025-01-01 23:05:00", "2025-01-05 12:04:00",
    "2025-02-01 19:03:00", "2025-01-01 05:02:00", "2025-06-01 13:01:00")),
    evitals_06 = rep(c(90, 100, 102, 103, 104), 2),
    evitals_12 = rep(c(90, 91, 92, 93, 94), 2)

  )

# arrest table
  arrest_table <- tibble::tibble(

    erecord_01 = rep(c("R1", "R2", "R3", "R4", "R5"), 2),
    earrest_01 = rep("No", 10)
  )

  # procedures table
  procedures_table <- tibble::tibble(

    erecord_01 = rep(c("R1", "R2", "R3", "R4", "R5"), 2),
    eprocedures_01 = rep(lubridate::as_datetime(c("2025-01-01 23:00:00",
    "2025-01-05 12:00:00", "2025-02-01 19:00:00", "2025-01-01 05:00:00",
    "2025-06-01 13:00:00")), 2),
    eprocedures_02 = rep("No", 10),
    eprocedures_03 = rep(c(16883004, 112798008, 78121007, 49077009,
                           673005), 2),
    eprocedures_05 = rep(1, 10),
    eprocedures_06 = rep(9923003, 10)

  )

# Run the function
# Return 95\% confidence intervals using the Wilson method
airway_01(df = NULL,
         patient_scene_table = patient_table,
         procedures_table = procedures_table,
         vitals_table = vitals_table,
         arrest_table = arrest_table,
         response_table = response_table,
         erecord_01_col = erecord_01,
         incident_date_col = incident_date,
         patient_DOB_col = patient_dob,
         epatient_15_col = epatient_15,
         epatient_16_col = epatient_16,
         eresponse_05_col = eresponse_05,
         eprocedures_01_col = eprocedures_01,
         eprocedures_02_col = eprocedures_02,
         eprocedures_03_col = eprocedures_03,
         eprocedures_05_col = eprocedures_05,
         eprocedures_06_col = eprocedures_06,
         earrest_01_col = earrest_01,
         evitals_01_col = evitals_01,
         evitals_06_col = evitals_06,
         evitals_12_col = evitals_12,
         confidence_interval = TRUE
         )

}
\author{
Samuel Kordik, BBA, BS, Nicolas Foss Ed.D., MS
}
