% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/control_traj.R
\name{control_scheme_DLI_freestate}
\alias{control_scheme_DLI_freestate}
\title{Discrete Linear Time-Invariant Free Final State Classic Control Scheme}
\usage{
control_scheme_DLI_freestate(t_max, A, B, S, Q_seq, R_seq)
}
\arguments{
\item{t_max}{Required. An integer total number of time points to determine the trajectory over}

\item{A}{Required. A \eqn{p x p} matrix of system coefficients}

\item{B}{Required. A \eqn{p x q} matrix of control weights}

\item{S}{A \eqn{p x p} final state weighting matrix}

\item{Q_seq}{A list of \eqn{t} \eqn{p x p} intermediate state weighting matrices or a single \eqn{p x p} intermediate state weighting matrix}

\item{R_seq}{A list of \eqn{t} \eqn{q x q} intermediate cost matrices or a single \eqn{q x q} cost matrix}
}
\value{
A list containing an entry labeled \code{gain_seq} containing either 1 or \code{t_max - 1} Kalman gain matrices and an entry labeled \code{cost_func} which contains a LQR function.
}
\description{
Given a system dynamics \eqn{A}, control input matrix \eqn{B}, final state weighting matrix \eqn{S},
 intermediate state weighting matrix sequence \eqn{Q_seq}, and cost matrix sequence \eqn{R_seq}, 
 calculates the Kalman gain sequence to minimize the LQR by time \eqn{t_max}.
  See section 2.2 of \insertCite{lewisOptimalControl2012}{netcontrol} for details.
}
\examples{

A = matrix(c(0,-3,-2,2,-2,1,-1,2,-1), 3,3)

#Normalize rows to sum to 1
A = solve(diag(rowSums(A))) \%*\% A

B = S = Q_seq = R_seq = diag(3)

CS = control_scheme_DLI_freestate(100, A, B, S, Q_seq, R_seq)

}
\references{
\insertRef{lewisOptimalControl2012}{netcontrol}
}
