% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/control_traj.R
\name{control_traj}
\alias{control_traj}
\title{Calculate the trajectory of a discrete linear time invariant system under a given control scheme}
\usage{
control_traj(t_max, x_0, A, B, theta = NA, gamma = NA, control_scheme,
  delta = NA, d_nosign = F, d_toggle = F, upper_bounds = NA,
  lower_bounds = NA, u_pos = F)
}
\arguments{
\item{t_max}{Required. An integer total number of time points to determine the trajectory over}

\item{x_0}{Required. A \eqn{p} length numeric vector of starting values}

\item{A}{Required. A \eqn{p x p} matrix of system coefficients}

\item{B}{Required. A \eqn{p x q} matrix of control weights}

\item{theta}{Optional. A \eqn{p x p} covariance matrix for state errors. If \code{NA}, state mechanics will be deterministic}

\item{gamma}{Optional. A \eqn{p x p} covariance matrix for observation errors. If \code{NA}, no observation/measurement error will be modelled.}

\item{control_scheme}{Required. A list containing an entry labeled \code{gain_seq} containing either 1 or \code{t_max - 1} Kalman gain matrices and an entry labeled \code{cost_func} which contains an appropriately constructed cost function}

\item{delta}{Optional. A vector of length 2, where the first entry contains the point of saturation for control inputs, and the second entry contains the saturation value for control inputs.}

\item{d_nosign}{Optional. Boolean. If \code{TRUE} and \code{delta} is not \code{NA}, control inputs are forced to be positive.}

\item{d_toggle}{Optional. Boolean. If \code{TRUE} and \code{delta} is not \code{NA}, control inputs are either 0 or the saturation value.}

\item{upper_bounds}{Optional. A \eqn{p} length vector of upper bounds on state values.}

\item{lower_bounds}{Optional. A \eqn{p} length vector of lower bounds on state values.}

\item{u_pos}{Optional. Boolean. If \code{TRUE} restricts control inputs to be positive,}
}
\value{
A list containing 4 entries: a `t_max x p` state value matrix, a `t_max x p` observation matrix, a `t_max-1 x q` matrix of control inputs and a `t_max` length vector of cost function values.
}
\description{
This function is designed to work with control_scheme objects generated by \code{control_scheme_DLI_freestate} 
In future versions of \code{netcontrol} this function will be used to simulate any control trajectory. 
For general details on control theory trajectories, see \insertCite{lewisOptimalControl2012}{netcontrol}.
}
\details{
CAUTION: Use of saturation parameters and/or bound parameters \code{delta, d_nosign, d_toggle, upper.bound, lower.bound, u.pos} 
leads to estimates of the optimal trajectory to be sub-optimal, as the Kalman gain calculations do not take any of those restrictions into account.
This functionality will be added later, and this caution statement removed at that time.
}
\examples{

A = matrix(c(0,-3,-2,2,-2,1,-1,2,-1), 3,3)

#Normalize rows to sum to 1
A = solve(diag(rowSums(A))) \%*\% A

B = S = Q_seq = R_seq = diag(3)

CS = control_scheme_DLI_freestate(100, A, B, S, Q_seq, R_seq)

traj = control_traj(100, rep(100,3), A, B, control_scheme = CS)

#First 5 control inputs
print(head(traj[[3]]))
}
\references{
\insertRef{lewisOptimalControl2012}{netcontrol}.
}
