% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nplot_legend.R
\name{nplot_legend}
\alias{nplot_legend}
\alias{print.netplot_legend}
\title{Add legend to a netplot object}
\usage{
nplot_legend(
  g,
  labels,
  pch,
  gp = grid::gpar(),
  ...,
  packgrob.args = list(side = "left")
)

\method{print}{netplot_legend}(x, y = NULL, newpage = TRUE, ...)
}
\arguments{
\item{g}{An object of class \link{netplot}.}

\item{labels}{Character vector of labels.}

\item{pch}{See \code{\link[graphics:points]{graphics::points()}}.}

\item{gp}{An object of class \code{\link[grid:gpar]{grid::gpar()}}}

\item{...}{Further arguments passed to \code{\link[grid:legendGrob]{grid::legendGrob()}}.}

\item{packgrob.args}{List of arguments passed to \code{\link[grid:grid.pack]{grid::packGrob()}}.}

\item{x}{An object of class \code{netplot_legend}.}

\item{y}{Ignored.}

\item{newpage}{Logical scalar. When \code{TRUE} it calls \code{\link[grid:grid.newpage]{grid::grid.newpage()}}.}
}
\value{
A frame grob.
}
\description{
Legends in \link{grid} graphics is a bit more complicated than in base graphics.
The function \code{nplot_legend} is a wrapper of \code{\link[grid:legendGrob]{grid::legendGrob()}} that makes
the process easier. Besides \code{labels}, the main visual arguments for the
figure ar passed through the \code{gp} argument (see examples).
}
\examples{
library(igraph)
library(netplot)
set.seed(1)
x <- sample_smallworld(1, 200, 5, 0.03)
V(x)$nsides <- sample(c(10, 4), 200, replace = TRUE)

g <- nplot(
  x,
  vertex.nsides = V(x)$nsides,
  vertex.color  = ifelse(V(x)$nsides == 4, "red", "steelblue"),
  edge.line.breaks = 5
  )

nplot_legend(
  g,
  labels = c("circle", "diamond", "edge"),
  pch    = c(21, 23, NA),
  gp     = gpar(
    fill = c("steelblue", "red", NA),
    lwd  = c(NA, NA, 1),
    col  = c(NA, NA, "purple")
    )
  )
grid.text("Legend to the left (default)", y = unit(.95, "npc"), just = "bottom")

nplot_legend(
  g,
  labels = c("circle", "diamond", "edge"),
  pch    = c(21, 23, NA),
  gp     = gpar(
    fill = c("steelblue", "red", NA),
    lwd  = c(NA, NA, 1),
    col  = c(NA, NA, "purple")
    ),
  # These two extra options set the legend to the bottom
  packgrob.args = list(side = "bottom"),
  ncol = 3
  )
grid.text("Legend bottom", y = unit(.95, "npc"), just = "bottom")


}
