% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/models.R
\name{fast_sbm}
\alias{fast_sbm}
\title{Sample from a SBM (fast)}
\usage{
fast_sbm(z, B)
}
\arguments{
\item{z}{Node labels (\eqn{n * 1})}

\item{B}{Connectivity matrix (\eqn{K * K})}
}
\value{
An adjacency matrix following SBM
}
\description{
Samples an adjacency matrix from a stochastic block model (SBM)
}
\details{
The function implements a fast algorithm for sampling sparse SBMs, by only
sampling the necessary nonzero entries. This function is adapted almost
verbatim from the original code by Aiyou Chen.
}
\examples{
B = pp_conn(n = 10^4, oir = 0.1, lambda = 7, pri = rep(1,3))$B
head(fast_sbm(sample(1:3, 10^4, replace = TRUE), B))

}
\keyword{models}
