% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matrixCreator.R
\name{matrixCreator}
\alias{matrixCreator}
\title{Convert Database to Functional Data Matrix Format}
\usage{
matrixCreator(
  database,
  paramZ = 35,
  useSequentialNumbering = FALSE,
  quiet = FALSE
)
}
\arguments{
\item{database}{A data frame created by \code{\link{databaseCreator}}, containing
voxel-level PET image data, including subject identifiers, coordinates, and intensity values.}

\item{paramZ}{An integer specifying the z-coordinate (slice) to extract. Default is \code{35}.}

\item{useSequentialNumbering}{\code{logical}. If \code{TRUE}, assigns sequential subject IDs
instead of extracting them from filenames. Not currently used inside this function. Default is \code{FALSE}.}

\item{quiet}{\code{logical}. If \code{TRUE}, suppresses progress messages. Default is \code{FALSE}.}
}
\value{
A numeric matrix where
\itemize{
  \item Each row represents one subject's PET values at the selected z-slice.
  \item Each column corresponds to a voxel (flattened as a 1D row).
}
}
\description{
Converts a PET image database (created via \code{\link{databaseCreator}}) into
a matrix format suitable for functional data analysis.
Each row of the resulting matrix corresponds to a subject, and each column to a voxel's PET intensity
values at a specified brain slice.
}
\details{
This function performs the following steps
\enumerate{
  \item Verifies that the specified z-slice exists in the database.
  \item Identifies the correct subject grouping column (\code{CN_number} or \code{AD_number}).
  \item Determines the matrix dimensions using \code{x} and \code{y} coordinates.
  \item Extracts PET intensities per subject at the given slice.
  \item Replaces any \code{NaN} values with \code{0} to ensure numerical stability.
}

This function typically follows \code{\link{databaseCreator}} and precedes
\code{\link{meanNormalization}} in the neuroSCC workflow.
}
\examples{
# NOTE: To keep example runtime short, only one synthetic PET file is used.
# For full analysis, expand the filename pattern accordingly.

# Step 1: Generate a database for a single subject
controlPattern <- "^syntheticControl1\\\\.nii\\\\.gz$"
databaseControls <- databaseCreator(pattern = controlPattern, control = TRUE, quiet = TRUE)

# Step 2: Convert the database into a matrix format
matrixControls <- matrixCreator(databaseControls, paramZ = 35, quiet = TRUE)

# Display dimensions of the matrix
dim(matrixControls)

}
\seealso{
\code{\link{databaseCreator}} for generating the input database. \cr
\code{\link{meanNormalization}} for scaling matrix data prior to SCC computation.
}
