% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_class.R, R/mapped_neurovec.R
\docType{class}
\name{MappedNeuroVecSource-class}
\alias{MappedNeuroVecSource-class}
\alias{MappedNeuroVecSource}
\title{MappedNeuroVecSource Class}
\usage{
MappedNeuroVecSource(file_name)
}
\arguments{
\item{file_name}{Character string specifying the path to the neuroimaging file.
Supported formats include NIFTI (.nii) and ANALYZE (.hdr/.img).}
}
\value{
A new \code{\linkS4class{MappedNeuroVecSource}} object containing:
\itemize{
  \item Meta information about the dataset
  \item File format details
  \item Dimensional information
}
}
\description{
A class used to produce a \code{\linkS4class{MappedNeuroVec}} instance. It encapsulates
the necessary information to create a memory-mapped representation of a 4D neuroimaging dataset.

Creates a \code{\linkS4class{MappedNeuroVecSource}} object that manages the memory
mapping between a neuroimaging file and memory space. This is typically used internally
by \code{\link{MappedNeuroVec}} but can be created directly for custom access patterns.
}
\details{
MappedNeuroVecSource acts as a factory for MappedNeuroVec objects. While it doesn't
have any additional slots beyond its parent class, it specifies the intent to create
a memory-mapped representation of the neuroimaging data. This class is typically used
in data loading pipelines where large datasets need to be accessed efficiently without
loading the entire dataset into memory.

Create a Memory-Mapped Source for Neuroimaging Data


The function performs several important checks:
\itemize{
  \item Validates file existence and permissions
  \item Reads and validates header information
  \item Ensures proper dimensionality (>= 3D)
  \item Verifies file format compatibility
}
}
\section{Inheritance}{

\code{MappedNeuroVecSource} inherits from:
\itemize{
  \item \code{\linkS4class{NeuroVecSource}}: Base class for NeuroVec source objects
}
}

\examples{
# Create a MappedNeuroVecSource
mapped_source <- new("MappedNeuroVecSource")

\donttest{
# Create source from NIFTI file
source <- MappedNeuroVecSource(system.file("extdata", "global_mask_v4.nii", package = "neuroim2"))

# Check dimensions
dim(source@meta_info)

# View header information
str(source@meta_info)
}

}
\seealso{
\code{\link{MappedNeuroVec}} for the main user interface,
\code{\link{read_header}} for header reading details
}
