% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/searchlight.R
\name{bootstrap_searchlight}
\alias{bootstrap_searchlight}
\title{Create a bootstrap spherical searchlight iterator}
\usage{
bootstrap_searchlight(mask, radius = 8, iter = 100)
}
\arguments{
\item{mask}{A \code{\linkS4class{NeuroVol}} object representing the brain mask.}

\item{radius}{A numeric value specifying the radius of the searchlight sphere
in voxel units. Default is 8.}

\item{iter}{An integer specifying the total number of searchlights to sample.
Default is 100.}
}
\value{
A \code{deferred_list} object containing \code{\linkS4class{ROIVolWindow}}
  objects, each representing a spherical searchlight region sampled from within the mask.
}
\description{
This function generates a spherical searchlight iterator by sampling regions
from within a brain mask. It creates searchlight spheres around random center
voxels, allowing the same surrounding voxel to belong to multiple searchlight samples.
}
\details{
Searchlight centers are sampled without replacement, but the same surrounding
voxel can belong to multiple searchlight samples.
}
\examples{
# Load an example brain mask
mask <- read_vol(system.file("extdata", "global_mask_v4.nii", package="neuroim2"))

# Generate a bootstrap searchlight iterator with a radius of 6 voxels

searchlights <- bootstrap_searchlight(mask, radius = 6)


}
