% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/common.R
\name{matrixToQuatern}
\alias{matrixToQuatern}
\title{Convert a Transformation Matrix to a Quaternion Representation}
\usage{
matrixToQuatern(mat)
}
\arguments{
\item{mat}{A numeric matrix with at least the top-left 3x3 portion containing
rotation/scaling. Often a 4x4 affine transform, but only the 3x3 top-left
submatrix is used in practice.}
}
\value{
A named \code{list} with two elements:
  \describe{
    \item{\code{quaternion}}{A numeric vector of length 3, \eqn{(b, c, d)},
      which—together with \eqn{a} derived internally—represents the rotation.}
    \item{\code{qfac}}{Either \code{+1} or \code{-1}, indicating whether the
      determinant of the rotation submatrix is positive or negative, respectively.}
  }
}
\description{
Extracts the rotation and scaling components from a 3x3 (or 4x4) transformation
matrix, normalizes them, and computes the corresponding quaternion parameters
and a sign factor (`qfac`) indicating whether the determinant is negative.
}
\details{
This function first checks and corrects for zero-length axes in the upper-left
corner of the matrix, then normalizes each column to extract the pure rotation.
If the determinant of the rotation submatrix is negative, the \code{qfac} is set
to \code{-1}, and the third column is negated. Finally, the quaternion parameters
(\eqn{a, b, c, d}) are computed following standard NIfTI-1 conventions for
representing the rotation in 3D.
}
\references{
- Cox RW. *Analysis of Functional NeuroImages* (AFNI) and NIfTI-1 quaternion
  conventions. \url{https://afni.nimh.nih.gov}
}
\seealso{
\code{\link{quaternToMatrix}} for the inverse operation, converting
quaternion parameters back to a transform matrix.
}
