% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_generic.R, R/axis.R
\name{perm_mat}
\alias{perm_mat}
\alias{perm_mat,NeuroSpace-method}
\title{Extract permutation matrix associated with an image}
\usage{
perm_mat(x, ...)

\S4method{perm_mat}{NeuroSpace}(x, ...)
}
\arguments{
\item{x}{A NeuroSpace object}

\item{...}{Additional arguments (not used)}
}
\value{
A numeric N x N \code{matrix} representing the permutation transform, where N is the dimensionality of the image.

A numeric N x N \code{matrix} representing the permutation transform, where N is the dimensionality of the image.
}
\description{
A permutation matrix defines how the native voxel coordinates can be transformed to standard (LPI) orientation.
}
\details{
a permutation matrix can be used to convert between cardinal image orientations.
For example, if an image is stored in "RPI" (Right-Posterior-Inferior) format, a coordinate in this space
can be converted to LPI (Left-Posterior-Inferior) by multiplying a coordinate vector by the permutation matrix.
}
\examples{

fname <- system.file("extdata", "global_mask_v4.nii", package="neuroim2")
vol <- read_vol(fname)
pmat <- perm_mat(space(vol))

vox <- c(12,12,8)
pvox <- vox \%*\% perm_mat(space(vol))

stopifnot(all(pvox == c(-12,12,8)))
}
