% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/binary_io.R
\name{read_elements,BinaryReader,numeric-method}
\alias{read_elements,BinaryReader,numeric-method}
\title{Read Elements from Binary Reader}
\usage{
\S4method{read_elements}{BinaryReader,numeric}(x, num_elements)
}
\arguments{
\item{x}{Object of class \linkS4class{BinaryReader}}

\item{num_elements}{Integer specifying number of elements to read}
}
\value{
Numeric vector of read elements
}
\description{
Read a specified number of elements from a \linkS4class{BinaryReader} object.
}
\examples{
\donttest{
# Create a temporary binary file with some test data
tmp <- tempfile()
con <- file(tmp, "wb")
test_data <- rnorm(100)
writeBin(test_data, con, size = 8)
close(con)

# Create reader and read the data
reader <- BinaryReader(tmp, byte_offset = 0L,
                      data_type = "DOUBLE", bytes_per_element = 8L)
data <- read_elements(reader, 100)
close(reader)

# Clean up
unlink(tmp)
}
}
