% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_generic.R
\name{read_elements}
\alias{read_elements}
\title{Read a sequence of elements from an input source}
\usage{
read_elements(x, num_elements)
}
\arguments{
\item{x}{the input channel}

\item{num_elements}{the number of elements to read}
}
\value{
A \code{vector} containing the elements read from \code{x}.
}
\description{
Read a sequence of elements from an input source
}
\examples{
# Create a temporary binary file with test data
tmp <- tempfile()
con <- file(tmp, "wb")
test_data <- rnorm(100)
writeBin(test_data, con, size = 8)
close(con)

# Create a BinaryReader and read the data
reader <- BinaryReader(tmp, byte_offset = 0L,
                      data_type = "double", bytes_per_element = 8L)
data <- read_elements(reader, 100)
close(reader)

# Clean up
unlink(tmp)
}
\keyword{internal}
