% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/roi.R
\name{spherical_roi_set}
\alias{spherical_roi_set}
\title{Create Multiple Spherical Regions of Interest}
\usage{
spherical_roi_set(bvol, centroids, radius, fill = NULL, nonzero = FALSE)
}
\arguments{
\item{bvol}{A \code{NeuroVol} or \code{NeuroSpace} instance}

\item{centroids}{A matrix of voxel coordinates where each row represents a centroid (i,j,k)}

\item{radius}{The radius in real units (e.g. millimeters) of the spherical ROIs}

\item{fill}{Optional value(s) to store as data. If provided, must be either a single value
or a vector with length equal to the number of ROIs}

\item{nonzero}{If \code{TRUE}, keep only nonzero elements from \code{bvol}}
}
\value{
A list of \code{ROIVolWindow} objects, one for each centroid
}
\description{
This function generates multiple spherical ROIs simultaneously, centered at the provided
voxel coordinates. It is more efficient than calling \code{spherical_roi} multiple times
when you need to create many ROIs.
}
\examples{
# Create a NeuroSpace object
sp1 <- NeuroSpace(c(10,10,10), c(1,2,3))

# Create multiple ROIs centered at different voxel coordinates
centroids <- matrix(c(5,5,5, 3,3,3, 7,7,7), ncol=3, byrow=TRUE)
rois <- spherical_roi_set(sp1, centroids, 3.5)

# Create ROIs with specific fill values
rois <- spherical_roi_set(sp1, centroids, 3.5, fill=c(1,2,3))

}
