% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_generic.R, R/binary_io.R
\name{write_elements}
\alias{write_elements}
\alias{write_elements,BinaryWriter,numeric-method}
\title{Write a sequence of elements from an input source}
\usage{
write_elements(x, els)

\S4method{write_elements}{BinaryWriter,numeric}(x, els)
}
\arguments{
\item{x}{the output channel}

\item{els}{the elements to write}
}
\value{
Invisibly returns \code{NULL} after writing the elements.
}
\description{
Write a sequence of elements from an input source
}
\examples{
# Create a temporary binary file for writing
tmp <- tempfile()
writer <- BinaryWriter(tmp, byte_offset = 0L,
                      data_type = "DOUBLE", bytes_per_element = 8L)

# Write some random data
data <- rnorm(100)
write_elements(writer, data)
close(writer)

# Read back the data to verify
reader <- BinaryReader(tmp, byte_offset = 0L,
                      data_type = "double", bytes_per_element = 8L)
read_data <- read_elements(reader, 100)
close(reader)

# Verify data was written correctly
all.equal(data, read_data)

# Clean up
unlink(tmp)
\donttest{
# Create a temporary binary file for writing
tmp <- tempfile()
writer <- BinaryWriter(tmp, byte_offset = 0L,
                      data_type = "DOUBLE", bytes_per_element = 8L)
# Write some data
write_elements(writer, rnorm(100))
close(writer)

# Clean up
unlink(tmp)
}
}
