% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGeneric.R, R/BrainSlice.R, R/BrainSpace.R, R/BrainVolume.R
\docType{methods}
\name{gridToIndex}
\alias{gridToIndex}
\alias{gridToIndex,BrainSlice,matrix-method}
\alias{gridToIndex,BrainSpace,matrix-method}
\alias{gridToIndex,BrainSpace,numeric-method}
\alias{gridToIndex,BrainVolume,matrix-method}
\alias{gridToIndex,BrainVolume,numeric-method}
\title{Generic function to convert N-dimensional grid coordinate to 1D indices}
\usage{
gridToIndex(x, coords)

\S4method{gridToIndex}{BrainSlice,matrix}(x, coords)

\S4method{gridToIndex}{BrainSpace,matrix}(x, coords)

\S4method{gridToIndex}{BrainSpace,numeric}(x, coords)

\S4method{gridToIndex}{BrainVolume,matrix}(x, coords)

\S4method{gridToIndex}{BrainVolume,numeric}(x, coords)
}
\arguments{
\item{x}{the object, typically a \code{BrainVolume} or \code{BrainSpace} instance.}

\item{coords}{a matrix where each row is a coordinate or a vector of length equal to \code{ndim(x)}}
}
\value{
a vector of indices
}
\description{
Generic function to convert N-dimensional grid coordinate to 1D indices
}

