% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGeneric.R, R/BrainMetaInfo.R, R/BrainSpace.R
\docType{methods}
\name{trans}
\alias{trans}
\alias{trans,BrainData-method}
\alias{trans,BrainMetaInfo-method}
\alias{trans,BrainSpace-method}
\alias{trans,NIfTIMetaInfo-method}
\title{Generic getter to extract image coordinate transformation}
\usage{
trans(x)

\S4method{trans}{BrainMetaInfo}(x)

\S4method{trans}{NIfTIMetaInfo}(x)

\S4method{trans}{BrainSpace}(x)

\S4method{trans}{BrainData}(x)
}
\arguments{
\item{x}{an object with a transformation}
}
\description{
Generic getter to extract image coordinate transformation
}
\details{
This function returns a transformation that can be used to go from "grid coordinates" to "real world coordinates" in millimeters.

This function returns a transformation that can be used to go from "grid coordinates" to "real world coordinates" in millimeters.
see \code{\linkS4class{BrainSpace}}
}
\examples{
bspace <- BrainSpace(c(10,10,10), c(2,2,2))
trans(bspace)
all.equal(dim(trans(bspace)), c(4,4))
}

