% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sod.R
\name{sod}
\alias{sod}
\alias{dsod}
\alias{psod}
\alias{qsod}
\alias{rsod}
\title{Standard Omega Distribution}
\usage{
dsod(x, alpha, beta, log = FALSE)

psod(q, alpha, beta, lower.tail = TRUE, log.p = FALSE)

qsod(p, alpha, beta, lower.tail = TRUE)

rsod(n, alpha, beta)
}
\arguments{
\item{x, q}{vector of quantiles.}

\item{alpha, beta}{are parameters.}

\item{log, log.p}{logical; if TRUE, probabilities p are given as log(p).}

\item{lower.tail}{logical; if TRUE (default), probabilities are
\eqn{P\left[ X\leq x\right]}, otherwise, \eqn{P\left[ X>x\right] }.}

\item{p}{vector of probabilities.}

\item{n}{number of observations. If \code{length(n) > 1}, the length is taken
to be the number required.}
}
\value{
\code{dsod} gives the density, \code{psod} gives the distribution
function, \code{qsod} gives the quantile function and \code{rsod} generates
random deviates.
}
\description{
Density, distribution function, quantile function and random generation for
the Standard Omega distribution.
}
\details{
The Standard Omega distribution with parameters
\eqn{\alpha} and \eqn{\beta}, has density
\deqn{f\left( x\right) =\alpha \beta x^{\beta -1}\frac{1}{1-x^{2\beta }}
\left( \frac{1+x^{\beta }}{1-x^{\beta }}\right) ^{-\alpha /2},}
where
\deqn{0<x<1,~\alpha ,\beta >0.}
}
\examples{
library(new.dist)
dsod(0.4, alpha=1, beta=2)
psod(0.4, alpha=1, beta=2)
qsod(.8, alpha=1, beta=2)
rsod(10, alpha=1, beta=2)
}
\references{
Birbiçer, İ. ve Genç, A. İ., 2022,
\emph{On parameter estimation of the standard omega distribution}. Journal of
Applied Statistics, 1-17.
}
