% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tpmd.R
\name{tpmd}
\alias{tpmd}
\alias{dtpmd}
\alias{ptpmd}
\alias{qtpmd}
\alias{rtpmd}
\title{Power Muth Distribution}
\usage{
dtpmd(x, beta = 1, alpha, log = FALSE)

ptpmd(q, beta = 1, alpha, lower.tail = TRUE, log.p = FALSE)

qtpmd(p, beta = 1, alpha, lower.tail = TRUE)

rtpmd(n, beta = 1, alpha)
}
\arguments{
\item{x, q}{vector of quantiles.}

\item{beta}{a scale parameter.}

\item{alpha}{a shape parameter.}

\item{log, log.p}{logical; if TRUE, probabilities p are given as log(p).}

\item{lower.tail}{logical; if TRUE (default), probabilities are
\eqn{P\left[ X\leq x\right]}, otherwise, \eqn{P\left[ X>x\right] }.}

\item{p}{vector of probabilities.}

\item{n}{number of observations. If \code{length(n) > 1}, the length is taken
to be the number required.}
}
\value{
\code{dtpmd} gives the density, \code{ptpmd} gives the distribution
function, \code{qtpmd} gives the quantile function and \code{rtpmd} generates
random deviates.
}
\description{
Density, distribution function, quantile function and random generation for
the Power Muth distribution with parameters \code{shape} and \code{scale}.
}
\details{
The Power Muth distribution with \code{shape} parameter \eqn{\alpha} and
\code{scale} parameter \eqn{\beta} has density
\deqn{f\left( x\right) =\frac{\alpha }{\beta ^\alpha }x^{\alpha -1}
\left( e^{\left(x/\beta \right) ^{\alpha }}-1\right)
\left( e^{\left( x/\beta \right)  ^{\alpha }-
\left( e^{\left( x/\beta \right) ^{\alpha }}-1\right) }\right), }
where
\deqn{x>0,~\alpha ,\beta>0.}
}
\note{
Hazard function;
\deqn{h\left( \beta ,\alpha \right) =\frac{\alpha }{\beta ^{\alpha }}
\left(e^{\left( x/\beta \right) ^{\alpha }}-1\right) x^{\alpha -1}}
}
\examples{
library(new.dist)
dtpmd(1, beta=2, alpha=3)
ptpmd(1,beta=2,alpha=3)
qtpmd(.5,beta=2,alpha=3)
rtpmd(10,beta=2,alpha=3)
}
\references{
Jodra, P., Gomez, H. W., Jimenez-Gamero,
M. D., & Alba-Fernandez, M. V. (2017).
\emph{The power Muth distribution} . Mathematical Modelling and Analysis, 22(2),
186-201.
}
