% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Game.R
\name{get_game_boxscore}
\alias{get_game_boxscore}
\title{Get boxscore by game, team, and player-type}
\usage{
get_game_boxscore(game = 2024020602, team = "home", player_type = "forwards")
}
\arguments{
\item{game}{integer Game ID}

\item{team}{string of 'home' or 'away'}

\item{player_type}{string of 'forwards', 'defense', or 'goalies'}
}
\value{
tibble with one row per player
}
\description{
\code{get_game_boxscore()} retrieves information on each player for a given set of \code{game}, \code{team}, and \code{player_type}, including but not limited to their ID, name, sweater number, goals, assists, +/-, hits, blocks, shots-on-goal, giveaways, takeaways, time on ice, and number of shifts. Access \code{get_games()} for \code{game} reference.
}
\examples{
boxscore_2024030411_FLA_defensemen <- get_game_boxscore(
  game=2024030411,
  team='away',
  player_type='defense'
)
}
