% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Skater.R
\name{get_skater_statistics}
\alias{get_skater_statistics}
\title{Get skater statistics}
\usage{
get_skater_statistics(
  season = get_season_now()$seasonId,
  teams = 1:100,
  game_types = 1:3,
  dates = c("2025-01-01"),
  report = "summary",
  is_aggregate = FALSE,
  is_game = FALSE
)
}
\arguments{
\item{season}{integer in YYYYYYYY}

\item{teams}{vector of integers Team ID(s)}

\item{game_types}{vector of integers where 1=pre-season, 2=regular, and
3=playoffs}

\item{dates}{vector of strings in 'YYYY-MM-DD'}

\item{report}{string}

\item{is_aggregate}{boolean}

\item{is_game}{boolean}
}
\value{
tibble with one row per skater or game
}
\description{
\code{get_skater_statistics()} retrieves information on each skater or game for a given set of \code{season}, \code{teams}, \code{game_types}, and \code{report}. \code{dates} must be given when paired with \code{is_game} as the default range will return incomplete data (too wide).  Access \code{get_configuration()} for what information each combination of \code{report}, \code{is_aggregate} and \code{is_game} can provide. Access \code{get_seasons()} for \code{season} and \code{dates} and \code{get_teams()} for \code{teams} references. Will soon be reworked for easier access.
}
\examples{
regular_skater_shootout_20242025 <- get_skater_statistics(
  season=20242025,
  game_types=c(2),
  report='shootout'
)
}
