% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Team.R
\name{roster}
\alias{roster}
\title{Access the roster for a team, season, and position}
\usage{
roster(team = 1, season = "current", position = "forwards")
}
\arguments{
\item{team}{integer ID (e.g., 21), character full name (e.g., 'Colorado
Avalanche'), OR three-letter code (e.g., 'COL'); see \code{\link[=teams]{teams()}} for
reference; ID is preferable as there now exists duplicate three-letter codes
(i.e., 'UTA' for 'Utah Hockey Club' and 'Utah Mammoth')}

\item{season}{integer in YYYYYYYY (e.g., 20242025); see \code{\link[=seasons]{seasons()}} for
reference}

\item{position}{character of 'f'/'forwards', 'd'/'defensemen', or
'g'/'goalies'}
}
\value{
data.frame with one row per player
}
\description{
\code{roster()} scrapes the roster for a given set of \code{team}, \code{season}, and
\code{position}.
}
\examples{
COL_defensemen_20242025 <- roster(
  team     = 21,
  season   = 20242025,
  position = 'D'
)
}
