% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/missing_ind.R
\name{miss_ind}
\alias{miss_ind}
\title{Add missingness indicators to existing data object}
\usage{
miss_ind(data, prefix = "miss_")
}
\arguments{
\item{data}{A numeric vector or array.}

\item{prefix}{A string used to name the indicator variables..}
}
\value{
An augmented data.frame with indicators for missingness patterns.
}
\description{
Add indicator columns to a data.frame showing the pattern of missingness.
}
\examples{
data <- data.frame(cbind(rnorm(10), runif(10)))
data[sample(nrow(data), 3), 1] <- NA
data[sample(nrow(data), 4), 2] <- NA
data <- miss_ind(data)
}
