% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meta_inla.R
\name{meta_inla}
\alias{meta_inla}
\title{Fitting a pairwise meta-analysis model using INLA.}
\usage{
meta_inla(
  datINLA,
  fixed.par = c(0, 1000),
  tau.prior = "uniform",
  tau.par = c(0, 5),
  type = "FE",
  approach = "arm-level",
  mreg = FALSE,
  verbose = FALSE,
  inla.strategy = "simplified.laplace",
  improve.hyperpar.dz = 0.75,
  correct = FALSE,
  correct.factor = 10
)
}
\arguments{
\item{datINLA}{An object of \code{create_INLA_dat_pair}}

\item{fixed.par}{A numerical vector specifying the parameter of the normal prior
density for mean treatment effect, first value is parameter for mean, second is for variance.}

\item{tau.prior}{A string specifying the prior density for the heterogeneity standard deviation,
options are 'uniform' for uniform prior and 'half-normal' for half-normal prior.}

\item{tau.par}{A numerical vector specifying the parameter of the prior
density for heterogenety stdev.
\itemize{
  \item \code{var.par = c(u, l)}: \code{u} is lower bound and \code{l} is upper
  bound when \code{var.prior = 'uniform'}
  \item \code{var.par = c(m, v)}: \code{m} is mean and \code{v} is variance
  when \code{var.prior = 'uniform'}
}}

\item{type}{A string indicating the type of the model, options are "FE", "RE".}

\item{approach}{A string indicating the approach of the model, options are "summary-level", "arm-level"}

\item{mreg}{Logical indicating whether covariate(s) should be incorporated to fit a
meta-regression model, default \code{FALSE}}

\item{verbose}{Logical indicating whether the program should run in a verbose model, default \code{FALSE}.}

\item{inla.strategy}{A string specfying the strategy to use for the approximations of INLA;
one of 'gaussian', 'simplified.laplace' (default) or 'laplace', see \code{?INLA::control.inla}.}

\item{improve.hyperpar.dz}{Step length in the standardized scale used in the construction of the grid, default 0.75,
see \code{INLA::inla.hyperpar}.}

\item{correct}{Logical Add correction for the Laplace approximation, default \code{FALSE},
see \code{INLA::inla.hyperpar}.}

\item{correct.factor}{Numerical Factor used in adjusting the correction factor if \code{correct=TRUE}, default 10,
see \code{INLA::inla.hyperpar}.}
}
\value{
\code{meta_inla} returns a \code{meta_inla} object with components:
}
\description{
\code{meta_inla} fits a pairwise meta-analysis model using INLA
}
\details{
The following model types are supported
\itemize{
  \item \code{FE}, fixed-effect model
  \item \code{RE}, random effects model
  }
}
\examples{
data('TBdat')
## Create the dataset suitable for INLA
TBdatINLA <- create_INLA_dat_pair(TBdat$TRT, TBdat$CON, TBdat$TRTTB, TBdat$CONTB)

## Fitting a random-effects model using arm-level approach
\dontrun{
if(requireNamespace('INLA', quietly = TRUE)){
 require('INLA', quietly = TRUE)
fit.TB.RE.INLA <- meta_inla(TBdatINLA, type = 'RE', approach = 'arm-level',
tau.prior = 'uniform', tau.par = c(0, 5))
}
}

}
