% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MC.R
\name{MC}
\alias{MC}
\title{The MC neural network}
\usage{
MC(X, y, L)
}
\arguments{
\item{X}{a list of samples from the functions domain.}

\item{y}{the function applied componentwise to each point in the domain.}

\item{L}{the Lipschitz constant for the function. Not necessarily global,
but could be an absolute upper limit of slope, over the domain.}
}
\value{
A neural network that gives the maximum convolution approximation
of a function whose outputs is \eqn{y} at \eqn{n} sample points given by
each row of \eqn{X}, when instantiated with ReLU.
}
\description{
This function implements the 1-D approximation scheme outlined in the References.

\strong{Note:} Only 1-D interpolation is implemented.
}
\examples{

seq(0, 3.1416, length.out = 200) -> X
sin(X) -> y
MC(X, y, 1) |> inst(ReLU, 0.25) # compare to sin(0.25)

}
\references{
Lemma 4.2.9. Jentzen, A., Kuckuck, B., and von Wurstemberger, P. (2023).
Mathematical introduction to deep learning: Methods, implementations,
and theory. \url{https://arxiv.org/abs/2310.20360}.
}
