% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Tun.R
\name{Tun}
\alias{Tun}
\title{Tun: The function that returns tunneling neural networks}
\usage{
Tun(n, d = 1)
}
\arguments{
\item{n}{The depth of the tunnel network where \eqn{n \in \mathbb{N} \cap [1,\infty)}.}

\item{d}{The dimension of the tunneling network. By default it is assumed to be \eqn{1}.}
}
\value{
A tunnel neural network of depth n. A tunneling neural
network is defined as the neural network \eqn{\mathsf{Aff}_{1,0}} for \eqn{n=1},
the neural network \eqn{\mathsf{Id}_1} for \eqn{n=1} and the neural network
\eqn{\bullet^{n-2}\mathsf{Id}_1} for \eqn{n >2}. For this to work we
must provide an appropriate \eqn{n} and instantiate with ReLU at some
real number \eqn{x}.
}
\description{
Tun: The function that returns tunneling neural networks
}
\examples{
Tun(4)
Tun(4, 3) |> view_nn()

Tun(5)
Tun(5, 3)

}
\references{
Definition 2.17. Rafi S., Padgett, J.L., Nakarmi, U. (2024) Towards an Algebraic Framework For
Approximating Functions Using Neural Network Polynomials
\url{https://arxiv.org/abs/2402.01058}
}
