% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_analysis_set.R
\name{make_analysis_set}
\alias{make_analysis_set}
\title{Make analysis set}
\usage{
make_analysis_set(
  var,
  stratified_data,
  data,
  maxdist = 0,
  maxcontrols = 20,
  silent = FALSE
)
}
\arguments{
\item{var}{Character of current exposure variable in
\code{\link{make_analysis_sets}}}

\item{stratified_data}{Stratified dataset, see \code{\link{make_knn_strata}}}

\item{data}{Original case control data}

\item{maxdist}{Reject any controls more than maxdist from their case}

\item{maxcontrols}{Maximum number of controls to keep per strata}

\item{silent}{Suppress exposure info useful for *apply/loop implementations}
}
\value{
A list of data frames with the \code{length} of number of exposures.
}
\description{
Set a maximum number of controls that are allowed to be matched to a case;
ensure that matched case-control pairs have a distance closer than the
predefined threshold; merge strata sharing same controls.
}
\details{
For more information, please refer to the vignette using
  \code{browseVignettes("nncc")}.
}
