% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NNCTFunctions.R
\name{mat2vec}
\alias{mat2vec}
\title{Conversion of a Matrix to a Vector}
\usage{
mat2vec(ct, byrow = TRUE)
}
\arguments{
\item{ct}{A matrix, in particular a contingency table}

\item{byrow}{A logical argument (default=\code{TRUE}). 
If \code{TRUE}, rows of \code{ct} are appended to obtain the vector
and if \code{FALSE} columns of \code{ct} are appended to obtain the vector.}
}
\value{
A \code{list} with two elements
\item{vec}{The \code{vector}ized form the matrix \code{ct}, 
by default appending the rows of \code{ct}}
\item{ind}{The \eqn{k^2 \times 2} matrix of 
entry indices (in the original matrix \code{ct}) 
whose i-th row corresponds to the i-th entry in \code{vec}.}
}
\description{
Converts the contingency table (or any matrix) \code{ct} to a \code{vector} 
by default row-wise (i.e., by appending
each row one after the other) or column-wise, 
and also returns the entry indices (in the original matrix \code{ct})
in a \eqn{k^2 \times 2} matrix
}
\examples{
n<-20  #or try sample(1:20,1)
Y<-matrix(runif(3*n),ncol=3)
ipd<-ipd.mat(Y)
cls<-sample(1:2,n,replace = TRUE)  #or try cls<-rep(1:2,c(10,10))
ct<-nnct(ipd,cls)
ct
mat2vec(ct)
mat2vec(ct,byrow=FALSE)

#an arbitrary 3x3 matrix
M<-matrix(sample(10:20,9),ncol=3)
M
mat2vec(M)
mat2vec(M,byrow=FALSE)

}
\seealso{
\code{\link{ind.nnsym}} and \code{\link{ind.seg.coeff}},
}
\author{
Elvan Ceyhan
}
