% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NNCTFunctions.R
\name{rassoc}
\alias{rassoc}
\title{Generation of Points Associated with a Given Set of Points}
\usage{
rassoc(X1, n2, asc.par, type)
}
\arguments{
\item{X1}{A set of 2D points representing the reference points, also referred as class 1 points.
The generated points are associated in a type=type sense with these points.}

\item{n2}{A positive integer representing the number of class 2 points to be generated.}

\item{asc.par}{A positive real number representing the association parameter. For \code{type="I"},
it is attraction probability, \code{p}, of class 2 points associated with a randomly selected class 1 point; 
for \code{type="C"} or \code{"U"}, it is the radius of association, \code{r0}, of class 2 points associated with a
randomly selected class 1 point;
for \code{type="G"}, it is the variance of the Gaussian marginals, where
the bivariate normal distribution has covariance \eqn{\sigma I_2} with \eqn{I_2} being the \eqn{2 \times 2} identity matrix.}

\item{type}{The type of the association pattern. Takes on values \code{"I"}, \code{"C"}, \code{"U"} and \code{"G"} 
for types I, C, U and G association patterns (see the description above).}
}
\value{
A \code{list} with the elements
\item{pat.type}{=\code{"ref.gen"} for the bivariate pattern of association of class 2 points with the reference points
(i.e., \eqn{X_1}), indicates reference points are required to be entered as an argument in the function}
\item{type}{The type of the point pattern}
\item{parameters}{The \code{asc.par} value specifying the level of association}
\item{ref.points}{The input set of reference points \eqn{X_1}, i.e., points with which generated class 2 points
are associated.}
\item{desc.pat}{Description of the point pattern}
\item{mtitle}{The \code{"main"} title for the plot of the point pattern}
\item{num.points}{The \code{vector} of two numbers, which are the number of generated class 2 points and
the number of reference (i.e., \eqn{X_1}) points.}
\item{xlimit,ylimit}{The possible ranges of the \eqn{x}- and \eqn{y}-coordinates of the generated and the reference points}
}
\description{
An object of class \code{"SpatPatterns"}.

Generates \code{n_2} 2D points associated with the given set of points (i.e., reference points) \eqn{X_1} in the
\code{type=type} fashion with the parameter=asc.par which specifies the level of association.
The generated points are intended to be from a different class, say class 2 (or \eqn{X_2} points) 
than the reference (i.e., \eqn{X_1} points, say class 1 points, denoted as \code{X1} as an argument 
of the function), say class 1 points). 

To generate \eqn{n_2} (denoted as \code{n2} as an argument of the function)\eqn{X_2} points, 
\eqn{n_2} of \eqn{X_1} points are randomly selected (possibly with replacement) and
for a selected \code{X1} point, say \eqn{x_{1ref}},
a new point from the class 2, say \eqn{x_{2new}}, is generated from a distribution specified
by the type argument.

In type I association, i.e., if \code{type="I"}, first a \eqn{Uniform(0,1)} number, \eqn{U}, is generated.
If \eqn{U \le p}, \eqn{x_{2new}} is generated (uniform in the polar coordinates) within a
circle with radius equal to the distance to the closest \eqn{X_1} point,
else it is generated uniformly within the smallest bounding box containing \eqn{X_1} points.

In the type C association pattern
the new point from the class 2, \eqn{x_{2new}}, is generated (uniform in the polar coordinates) within a circle
centered at \eqn{x_{1ref}} with radius equal to \eqn{r_0},
in type U association pattern \eqn{x_{2new}} is generated similarly except it is uniform in the circle.

In type G association, \eqn{x_{2new}} is generated from the bivariate normal distribution centered at \eqn{x_{1ref}} with covariance
\eqn{\sigma I_2} where \eqn{I_2} is \eqn{2 \times 2} identity matrix.

See \insertCite{ceyhan:serra-2014;textual}{nnspat} for more detail.
}
\examples{
n1<-20; n2<-1000;  #try also n1<-10; n2<-1000;

#with default bounding box (i.e., unit square)
X1<-cbind(runif(n1),runif(n1))

Xdat<-rassoc(X1,n2,asc.par=.05,type="G") #try other types as well
Xdat
summary(Xdat)
plot(Xdat,asp=1)
plot(Xdat)

#with type U association
Xdat<-rassoc(X1,n2,asc.par=.1,type="U")
Xdat
summary(Xdat)
plot(Xdat,asp=1)
plot(Xdat)

#with type C association
Xdat<-rassoc(X1,n2,asc.par=.1,type=2) #2 is for "C"
Xdat
summary(Xdat)
plot(Xdat,asp=1)
plot(Xdat)

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{rassocI}}, \code{\link{rassocC}}, \code{\link{rassocU}}, and \code{\link{rassocG}}
}
\author{
Elvan Ceyhan
}
