% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ptmvn_sample.R
\name{rptmvn}
\alias{rptmvn}
\title{Draw one sample of the underlying GP responses for a partially censored Gaussian
process using sequential nearest neighbor (SNN) method}
\usage{
rptmvn(
  y,
  cens_lb,
  cens_ub,
  mask_cens,
  m = 30,
  covmat = NULL,
  locs = NULL,
  cov_name = NULL,
  cov_parm = NULL,
  NN = NULL,
  ordering = 0,
  seed = NULL
)
}
\arguments{
\item{y}{uncensored responses of length n, where n is the number of all responses}

\item{cens_lb}{lower bound vector for TMVN of length n}

\item{cens_ub}{upper bound vector for TMVN of length n}

\item{mask_cens}{mask for censored responses (also locations) of length n}

\item{m}{positive integer for the number of nearest neighbors used}

\item{covmat}{n-by-n dense covariance matrix, either \code{covmat} or \code{locs},
\code{cov_name}, and \code{cov_parms} need to be provided}

\item{locs}{location matrix n X d}

\item{cov_name}{covariance function name from the \code{GpGp} package}

\item{cov_parm}{parameters for the covariance function from the \code{GpGp} package}

\item{NN}{n X m matrix for nearest neighbors. i-th row is the nearest neighbor indices of y_i. \code{NN[i, 1]} should be \code{i}}

\item{ordering}{\code{0} for do not reorder, \code{1} for variance descending order, \code{2} for maximin ordering}

\item{seed}{set seed for reproducibility}
}
\value{
a vector of length n representing the underlying GP responses
}
\description{
Draw one sample of the underlying GP responses for a partially censored Gaussian
process using sequential nearest neighbor (SNN) method
}
\examples{
library(GpGp)
library(RANN)
library(nntmvn)
set.seed(123)
x <- matrix(seq(from = 0, to = 1, length.out = 51), ncol = 1)
cov_name <- "matern15_isotropic"
cov_parm <- c(1.0, 0.1, 0.001) #' variance, range, nugget
cov_func <- getFromNamespace(cov_name, "GpGp")
covmat <- cov_func(cov_parm, x)
y <- t(chol(covmat)) \%*\% rnorm(length(x))
mask <- y < 0.3
y_cens <- y
y_cens[mask] <- NA
lb <- rep(-Inf, 100)
ub <- rep(0.3, 100)
m <- 10
y_samp_mtd1 <- rptmvn(y_cens, lb, ub, mask,
  m = m, locs = x,
  cov_name = cov_name, cov_parm = cov_parm, seed = 123
)
y_samp_mtd2 <- rptmvn(y_cens, lb, ub, mask,
  m = m, covmat = covmat,
  seed = 123
)
plot(x, y_cens, ylim = range(y))
points(x[mask, ], y[mask], col = "blue")
plot(x, y_cens, ylim = range(y))
points(x[mask, ], y_samp_mtd1[mask], col = "red")
plot(x, y_cens, ylim = range(y))
points(x[mask, ], y_samp_mtd2[mask], col = "brown")

}
