% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transparent.R
\name{ACE_bounds}
\alias{ACE_bounds}
\title{Bounds for the Average Causal Effect (ACE).}
\usage{
ACE_bounds(n_y0x0z0, n_y1x0z0 = NA, n_y0x1z0 = NA, n_y1x1z0 = NA,
  n_y0x0z1 = NA, n_y1x0z1 = NA, n_y0x1z1 = NA, n_y1x1z1 = NA)
}
\arguments{
\item{n_y0x0z0}{Number of individuals with Y=0, X=0, Z=0.
Alternatively, a vector with elements
(either counts, p(y, x , z) or p(y, x | z)) in the order of the arguments.}

\item{n_y1x0z0}{Number of individuals with Y=1, X=0, Z=0.}

\item{n_y0x1z0}{Number of individuals with Y=0, X=1, Z=0.}

\item{n_y1x1z0}{Number of individuals with Y=1, X=1, Z=0.}

\item{n_y0x0z1}{Number of individuals with Y=0, X=0, Z=1.}

\item{n_y1x0z1}{Number of individuals with Y=1, X=0, Z=1.}

\item{n_y0x1z1}{Number of individuals with Y=0, X=1, Z=1.}

\item{n_y1x1z1}{Number of individuals with Y=1, X=1, Z=1.}
}
\value{
The empirical bounds for the ACE.
}
\description{
The empirical bounds for the Average Causal Effect (ACE),
   under the assumptions of the Instrumental Variable (IV) model.
}
\examples{
ACE_bounds(158, 14, 0, 0, 52, 12, 23, 78)
ACE_bounds(c(158, 14, 0, 0, 52, 12, 23, 78))
ACE_bounds(99, 1027, 30, 233, 84, 935, 31, 422)
ACE_bounds(c(99, 1027, 30, 233, 84, 935, 31, 422))
}
\references{
{Richardson, T. S.; Robins, J. M. (2014).
   ACE Bounds; SEMs with Equilibrium Conditions.
   \emph{Statist. Sci. 29, no. 3, 363-366.}.}
}

