% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/finitepop.R
\name{Get_pvalues_CONT}
\alias{Get_pvalues_CONT}
\title{Exact finite population p-values under the sharp null for Compliers.}
\usage{
Get_pvalues_CONT(obs_y0x0z0, obs_y1x0z0, obs_y0x0z1, obs_y1x0z1, obs_y0x1z1,
  obs_y1x1z1, useGLR = FALSE, justexactp = TRUE, maxonly = TRUE)
}
\arguments{
\item{obs_y0x0z0}{Number of observed individuals with Y=0, X=0, Z=0.}

\item{obs_y1x0z0}{Number of observed individuals with Y=1, X=0, Z=0.}

\item{obs_y0x0z1}{Number of observed individuals with Y=0, X=0, Z=1.}

\item{obs_y1x0z1}{Number of observed individuals with Y=1, X=0, Z=1.}

\item{obs_y0x1z1}{Number of observed individuals with Y=0, X=1, Z=1.}

\item{obs_y1x1z1}{Number of observed individuals with Y=1, X=1, Z=1.}

\item{useGLR}{Whether or not to use the generalized likelihood ratio
(GLR) test statistic.}

\item{justexactp}{Just find the total probability of the critical
region for each population, or the total probabilty of the
sampling distribution (which should be 1).}

\item{maxonly}{Whether to return only the maximum
population-specific p-value, or all the population-specific
p-values.}
}
\value{
Exact population-specific p-value(s)
   for a given observed dataset.
}
\description{
Find the exact population-specific p-values
   under the sharp null for Compliers,
   for each compatible population with only Compliers and Never Takers.
}
\examples{
Get_pvalues_CONT(16, 1, 5, 1, 2, 8)
Get_pvalues_CONT(16, 1, 5, 1, 2, 8, TRUE, FALSE)
Get_pvalues_CONT(16, 1, 5, 1, 2, 8, TRUE, FALSE, FALSE)
Get_pvalues_CONT(158, 14, 52, 12, 23, 78)
}
\references{
{Loh, W. W., & Richardson, T. S. (2015).
   A Finite Population Likelihood Ratio Test of the
   Sharp Null Hypothesis for Compliers.
   \emph{In Thirty-First Conference on
   Uncertainty in Artificial Intelligence}.
   \href{http://auai.org/uai2015/proceedings/papers/97.pdf}{[paper]}}
}

