% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/npMeanSingle.R
\name{npMeanSingle}
\alias{npMeanSingle}
\title{A test for the mean of a bounded random variable based on a single sample
of iid observations.}
\usage{
npMeanSingle(x, mu, lower = 0, upper = 1, alternative = "two.sided",
  iterations = 5000, alpha = 0.05, epsilon = 1 * 10^(-6),
  ignoreNA = FALSE, max.iterations = 100000)
}
\arguments{
\item{x}{a (non-empty) numeric vector of data values.}

\item{mu}{threshold value for the null hypothesis.}

\item{lower, upper}{the theoretical lower and upper bounds on the data
outcomes known ex-ante before gathering the data.}

\item{alternative}{a character string describing the alternative
hypothesis, can take values "greater", "less" or "two.sided".}

\item{iterations}{the number of iterations used, should not be changed if
the exact solution should be derived}

\item{alpha}{the type I error.}

\item{epsilon}{the tolerance in terms of probability of the Monte Carlo
simulations.}

\item{ignoreNA}{if \code{TRUE}, NA values will be omitted. Default:
\code{FALSE}}

\item{max.iterations}{the maximum number of iterations that should be
carried out. This number could be increased to achieve greater accuracy in
cases where the difference between the threshold probability and theta is
small. Default: \code{10000}}
}
\value{
A list with class "nphtest" containing the following components:

\item{method}{ a character string indicating the name and type of the test
that was performed.  } \item{data.name}{ a character string giving the
name(s) of the data.  } \item{alternative}{ a character string describing
the alternative hypothesis.  } \item{estimate}{ the estimated mean or
difference in means depending on whether it was a one-sample test or a
two-sample test.  } \item{probrej}{ numerical estimate of the rejection
probability of the randomized test, derived by taking an average of
\code{iterations} realizations of the rejection probability.  }
\item{bounds}{ the lower and upper bounds of the variables.  }
\item{null.value}{ the specified hypothesized value of the correlation
between the variables.  } \item{alpha}{ the type I error } \item{theta}{
the parameter that minimizes the type II error.  } \item{pseudoalpha}{
\code{theta}*\code{alpha}, this is the level used when calculating the
average rejection probability during the iterations.  } \item{rejection}{
logical indicator for whether or not the null hypothesis can be rejected.
} \item{iterations}{ the number of iterations that were performed.  }
}
\description{
This test requires that the user knows upper and lower bounds before
gathering the data such that the properties of the data generating process
imply that all observations will be within these bounds. The data input
consists of a sequence of observations, each being an independent
realization of the random variable. No further distributional assumptions
are made.
}
\details{
For any \eqn{\mu} that lies between the two bounds, under alternative =
"greater", it is a test of the null hypothesis \eqn{H_0 : E(X) \le \mu}
against the alternative hypothesis \eqn{H_1 : E(X) > \mu}.

Using the known bounds, the data is transformed to lie in [0, 1] using an
affine transformation. Then the data is randomly transformed into a new
data set that has values 0, \code{mu} and 1 using a mean preserving
transformation. The exact randomized binomial test is then used to
calculate the rejection probability of this under new data when level is
\code{theta}*\code{alpha}. This random transformation is repeated
\code{iterations} times. If the average rejection probability is greater
than theta, one can reject the null hypothesis. If however the average
rejection probability is too close to theta then the iterations are
continued. The values of \code{theta} and a value of \code{mu} in the
alternative hypothesis is found in an optimization procedure to maximize
the set of parameters in the alternative hypothesis under which the type II
error probability is below 0.5. Please see the cited paper below for
further information.
}
\examples{

## test whether Americans gave more than 5 dollars in a round of
## the Ultimatum game
data(bargaining)
us_offers <- bargaining$US
npMeanSingle(us_offers, mu = 5, lower = 0, upper = 10, alternative =
"greater", ignoreNA = TRUE) ## no rejection

## test if the decrease in pain before and after the surgery is smaller
## than 50
data(pain)
pain$decrease <- with(pain, before - after)
without_pc <- pain[pain$pc == 0, "decrease"]
npMeanSingle(without_pc, mu = 50, lower = 0, upper = 100,
alternative = "less")

}
\references{
Schlag, Karl H. 2008, A New Method for Constructing Exact Tests
without Making any Assumptions, Department of Economics and Business
Working Paper 1109, Universitat Pompeu Fabra. Available at
\url{https://ideas.repec.org/p/upf/upfgen/1109.html}.
}
\seealso{
\url{https://homepage.univie.ac.at/karl.schlag/statistics.php}
}
\author{
Karl Schlag, Peter Saffert and Oliver Reiter
}
\keyword{mean}
\keyword{sample}
\keyword{single}
\keyword{test}
