% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shape_sim.R
\name{shape_sim}
\alias{shape_sim}
\title{Generate the shape of demand}
\usage{
shape_sim(periods_number, shape_number, shape_type = "random")
}
\arguments{
\item{periods_number}{Number of time periods of the products life cycle}

\item{shape_number}{Number of generic shapes}

\item{shape_type}{Type of shape to generate. It can take the values: "triangle",
"trapezoid", "bass", "random" and "intro & growth".
  The type "random" picks one of the types "triangle",
"trapezoid", "bass" randomly for each product.
The type "intro & growth" is used for the shapes of the introduction
and growth phases.}
}
\value{
A numeric dateframe of three columns: time, shape and assigned_shape
}
\description{
Generate the shape of demand for new products by specifying their life cycle
shape and the length of their life cycle
}
\examples{
shape_sim(periods_number=20, shape_number=5)
shape_sim(periods_number=20, shape_number=5,shape_type="trapezoid")
}
