% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.o2plsda}
\alias{plot.o2plsda}
\title{Score, VIP or loading plot for the O2PLS results}
\usage{
\method{plot}{o2plsda}(
  x,
  type = "score",
  group = NULL,
  ind = c(1, 2),
  color = NULL,
  top = 20,
  ellipse = TRUE,
  order = FALSE,
  pt.size = 3,
  label = TRUE,
  label.size = 4,
  repel = FALSE,
  rotation = FALSE,
  ...
)
}
\arguments{
\item{x}{an o2plsda object}

\item{type}{score, vip or loading}

\item{group}{color used for score plot}

\item{ind}{which components to be used for score plot or loading plot}

\item{color}{color used for score or loading plot}

\item{top}{the number of largest loading value to plot}

\item{ellipse}{TRUE/FALSE}

\item{order}{order by the value or not}

\item{pt.size}{point size}

\item{label}{plot label or not (TRUE/FALSE)}

\item{label.size}{label size}

\item{repel}{use ggrepel to show the label or not}

\item{rotation}{flip the figure or not (TRUE/FALSE)}

\item{...}{For consistency}
}
\value{
a ggplot2 object
}
\description{
Score, VIP or loading plot for the O2PLS results
}
\examples{
X <- matrix(rnorm(50),10,5)
Y <- matrix(rnorm(50),10,5)
fit <- o2pls(X,Y,2,1,1)
yy <- rep(c(0,1),5)
fit0 <- oplsda(fit,yy,2)
plot(fit0, type="score", group = factor(yy))
}
\author{
Kai Guo
}
