% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/o2pls.R
\name{o2pls}
\alias{o2pls}
\title{fit O2PLS model with best nc, nx, ny}
\usage{
o2pls(X, Y, nc, nx, ny, scale = FALSE, center = FALSE)
}
\arguments{
\item{X}{a Numeric matrix (input)}

\item{Y}{a Numeric matrix (input)}

\item{nc}{Integer. Number of joint PLS components.}

\item{nx}{Integer. Number of orthogonal components in X}

\item{ny}{Integer. Number of orthogonal components in Y}

\item{scale}{boolean values determining if data should be scaled or not}

\item{center}{boolean values determining if data should be centered or not}
}
\value{
An object containing
   \item{Xscore}{Joint \eqn{X} scores}
   \item{Xloading}{Joint \eqn{X} loadings}
   \item{Yscore}{Joint \eqn{Y} scores}
   \item{Yloading}{Joint \eqn{Y} loadings}
   \item{TYosc}{Orthogonal \eqn{X} scores}
   \item{PYosc}{Orthogonal \eqn{X} loadings}
   \item{WYosc}{Orthogonal \eqn{X} weights}
   \item{UXosc}{Orthogonal \eqn{Y} scores}
   \item{PXosc}{Orthogonal \eqn{Y} loadings}
   \item{CXosc}{Orthogonal \eqn{Y} weights}
   \item{BU}{Regression coefficient in \code{Tt} ~ \code{U}}
   \item{BT}{Regression coefficient in \code{U} ~ \code{Tt}}
   \item{Xhat}{Prediction of \eqn{X} with \eqn{Y}}
   \item{Yhat}{Prediction of \eqn{Y} with \eqn{X}}
   \item{R2Xhat}{Variation of the predicted \eqn{X} as proportion of variation in \eqn{X}}
   \item{R2Yhat}{Variation of the predicted \eqn{Y} as proportion of variation in \eqn{Y}}
   \item{R2X}{Variation of the modeled part in \eqn{X} (defined by Joint + Orthogonal variation) as proportion of total variation in \eqn{X}}
   \item{R2Y}{Variation of the modeled part in \eqn{Y} (defined by Joint + Orthogonal variation) as proportion of total variation in \eqn{Y}}
   \item{R2Xcorr}{Variation of the joint part in \eqn{X} }
   \item{R2Ycorr}{Variation of the joint part in \eqn{Y} }
   \item{R2Xo}{Variation of the orthogonal part in \eqn{X} as proportion of variation in \eqn{X}}
   \item{R2Yo}{Variation of the orthogonal part in \eqn{Y} as proportion of variation in \eqn{Y}}
   \item{R2Xp}{Variation in \eqn{X} joint part predicted by \eqn{Y} Joint part}
   \item{R2Yp}{Variation in \eqn{Y} joint part predicted by \eqn{X} Joint part}
   \item{varXj}{Variation in each Latent Variable (LV) in \eqn{X} Joint part}
   \item{varYj}{Variation in each Latent Variable (LV) in \eqn{Y} Joint part}
   \item{varXorth}{Variation in each Latent Variable (LV) in \eqn{X} Orthogonal part}
   \item{varYorth}{Variation in each Latent Variable (LV) in \eqn{Y} Orthogonal part}
   \item{Exy}{Residuals in \eqn{X}}
   \item{Fxy}{Residuals in \eqn{Y}}
}
\description{
fit O2PLS model with best nc, nx, ny
}
\examples{
set.seed(123)
X = matrix(rnorm(500),50,10)
Y = matrix(rnorm(500),50,10)
X = scale(X, scale = TRUE)
Y = scale(Y, scale = TRUE)
fit <- o2pls(X, Y, 1, 2, 2)
summary(fit)
}
\author{
Kai Guo
}
