% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api_files.R
\name{files_list_request}
\alias{files_list_request}
\title{API files: get list request}
\usage{
files_list_request(purpose = NULL, api_key = api_get_key())
}
\arguments{
\item{purpose}{NULL/string, only return files with the given purpose}

\item{api_key}{string, OpenAI API key
(see https://platform.openai.com/account/api-keys)}
}
\value{
\link[httr]{content} of the httr \link[httr]{response} object
or SimpleError (\link[base]{conditions}) enhanced with
two additional fields: `status_code` (response$status_code)
and `message_long` (built on response content)
}
\description{
Returns a list of files that belong to the user's organization. To get more details, visit:
https://platform.openai.com/docs/api-reference/files/list
}
\examples{
\dontrun{
res_content <- files_list_request()
if (!is_error(res_content)) {
  files_list_df <- files_fetch_list(res_content)
  print(files_list_df)
}
}

}
