% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map.R
\name{mapPolygon}
\alias{mapPolygon}
\title{Add a Polygon to a Map}
\usage{
mapPolygon(
  longitude,
  latitude,
  density = NULL,
  angle = 45,
  border = NULL,
  col = NA,
  lty = par("lty"),
  ...,
  fillOddEven = FALSE
)
}
\arguments{
\item{longitude}{numeric vector of longitudes of points defining the polygon,
to be plotted, or an object from
which both longitude and latitude can be inferred (e.g. a coastline file, or
the return value from \code{\link[=mapLocator]{mapLocator()}}), in which case the \code{latitude}
argument are ignored.}

\item{latitude}{numeric vector of latitudes of points to be plotted (ignored
if both longitude and latitude can be determined from the first argument).}

\item{density, angle, border, col, lty, ..., fillOddEven}{handled as
\code{\link[=polygon]{polygon()}} handles the same arguments.}
}
\description{
\code{mapPolygon} adds a polygon to an existing map.
}
\examples{
\donttest{
library(oce)
data(coastlineWorld)
data(topoWorld)

# Bathymetry near southeastern Canada
par(mfrow = c(1, 1), mar = c(2, 2, 1, 1))
cm <- colormap(zlim = c(-5000, 0), col = oceColorsGebco)
drawPalette(colormap = cm)
lonlim <- c(-60, -50)
latlim <- c(40, 60)
mapPlot(coastlineWorld,
    longitudelim = lonlim,
    latitudelim = latlim, projection = "+proj=merc", grid = FALSE
)
mapImage(topoWorld, colormap = cm)
mapPolygon(coastlineWorld[["longitude"]], coastlineWorld[["latitude"]], col = "lightgray")
}

}
\seealso{
A map must first have been created with \code{\link[=mapPlot]{mapPlot()}}.

Other functions related to maps: 
\code{\link{formatPosition}()},
\code{\link{lonlat2map}()},
\code{\link{lonlat2utm}()},
\code{\link{map2lonlat}()},
\code{\link{mapArrows}()},
\code{\link{mapAxis}()},
\code{\link{mapContour}()},
\code{\link{mapCoordinateSystem}()},
\code{\link{mapDirectionField}()},
\code{\link{mapGrid}()},
\code{\link{mapImage}()},
\code{\link{mapLines}()},
\code{\link{mapLocator}()},
\code{\link{mapLongitudeLatitudeXY}()},
\code{\link{mapPlot}()},
\code{\link{mapPoints}()},
\code{\link{mapScalebar}()},
\code{\link{mapText}()},
\code{\link{mapTissot}()},
\code{\link{oceCRS}()},
\code{\link{oceProject}()},
\code{\link{shiftLongitude}()},
\code{\link{usrLonLat}()},
\code{\link{utm2lonlat}()}
}
\author{
Dan Kelley
}
\concept{functions related to maps}
