% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interface.R
\name{odin_ir}
\alias{odin_ir}
\title{Return detailed information about an odin model}
\usage{
odin_ir(x, parsed = FALSE)
}
\arguments{
\item{x}{An \code{odin_generator} function, as created by
\code{odin::odin}}

\item{parsed}{Logical, indicating if the representation should be
parsed and converted into an R object.  If \code{FALSE} we
return a json string.}
}
\description{
Return detailed information about an odin model.  This is the
mechanism through which \link{coef} works with odin.
}
\section{Warning}{


The returned data is subject to change for a few versions while I
work out how we'll use it.
}

\examples{
exp_decay <- odin::odin({
  deriv(y) <- -0.5 * y
  initial(y) <- 1
}, target = "r")
odin::odin_ir(exp_decay)
coef(exp_decay)
}
