% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R, R/mixnorm.R
\name{dmixnorm_cpp}
\alias{dmixnorm_cpp}
\alias{pmixnorm_cpp}
\alias{rmixnorm_cpp}
\alias{dmixnorm}
\alias{pmixnorm}
\alias{rmixnorm}
\title{Mixture of normal distributions}
\usage{
dmixnorm_cpp(x, mean, Sigma, proportions)

pmixnorm_cpp(x, mean, Sigma, proportions, abseps = 0.001)

rmixnorm_cpp(mean, Sigma, proportions)

dmixnorm(x, mean, Sigma, proportions)

pmixnorm(x, mean, Sigma, proportions, abseps = 0.001)

rmixnorm(n = 1, mean, Sigma, proportions)
}
\arguments{
\item{x}{[\code{numeric(p)}]\cr
A quantile vector of length \code{p}, where \code{p} is the dimension.}

\item{mean}{[\code{matrix(nrow = p, ncol = c)}]\cr
The mean vectors for each component in columns.}

\item{Sigma}{[\code{matrix(nrow = p^2, ncol = c)}]\cr
The vectorized covariance matrices for each component in columns.}

\item{proportions}{[\code{numeric(c)}]\cr
The non-negative mixing proportions for each components.

If proportions do not sum to unity, they are rescaled to do so.}

\item{abseps}{[\code{numeric(1)}]\cr
The absolute error tolerance.}

\item{n}{[\code{integer(1)}]\cr
The number of requested samples.}
}
\value{
For \code{dmixnorm()}: The density value.

For \code{pmixnorm()}: The value of the distribution function.

For \code{rmixnorm()}: If \code{n = 1} a \code{vector} of length \code{p} (note
that it is a column vector for \code{rmixnorm_cpp()}), else
a \code{matrix} of dimension \code{n} times \code{p} with samples as rows.
}
\description{
The function \code{dmixnorm()} computes the density of a mixture of multivariate
normal distribution.

The function \code{pmixnorm()} computes the cumulative distribution function of a
mixture of multivariate normal distribution.

The function \code{rmixnorm()} samples from a mixture of multivariate normal
distribution.

The functions with suffix \verb{_cpp} perform no input checks, hence are faster.

The univariate normal mixture is available as the special case \code{p = 1}.
}
\details{
\code{pmixnorm()} is based on \code{mvtnorm::pmvnorm} with the randomized
Quasi-Monte-Carlo procedure by Genz and Bretz. The argument \code{abseps} controls
the accuracy of the Gaussian integral approximation.
}
\examples{
x <- c(0, 0)
mean <- matrix(c(-1, -1, 0, 0), ncol = 2)
Sigma <- matrix(c(diag(2), diag(2)), ncol = 2)
proportions <- c(0.7, 0.3)

# compute density
dmixnorm(x = x, mean = mean, Sigma = Sigma, proportions = proportions)

# compute CDF
pmixnorm(x = x, mean = mean, Sigma = Sigma, proportions = proportions)

# sample
rmixnorm(n = 3, mean = mean, Sigma = Sigma, proportions = proportions)
}
\seealso{
Other simulation helpers: 
\code{\link{Simulator}},
\code{\link{correlated_regressors}()},
\code{\link{ddirichlet_cpp}()},
\code{\link{dmvnorm_cpp}()},
\code{\link{dtnorm_cpp}()},
\code{\link{dwishart_cpp}()},
\code{\link{gaussian_tv}()},
\code{\link{simulate_markov_chain}()}
}
\concept{simulation helpers}
\keyword{distribution}
