% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rtf.R
\name{to_rtf}
\alias{to_rtf}
\title{Convert officer objects to RTF}
\usage{
to_rtf(x, ...)
}
\arguments{
\item{x}{object to convert to RTF. Supported
objects are:
\itemize{
\item \code{\link[=ftext]{ftext()}}
\item \code{\link[=external_img]{external_img()}}
\item \code{\link[=run_autonum]{run_autonum()}}
\item \code{\link[=run_columnbreak]{run_columnbreak()}}
\item \code{\link[=run_linebreak]{run_linebreak()}}
\item \code{\link[=run_word_field]{run_word_field()}}
\item \code{\link[=run_reference]{run_reference()}}
\item \code{\link[=run_pagebreak]{run_pagebreak()}}
\item \code{\link[=hyperlink_ftext]{hyperlink_ftext()}}
\item \code{\link[=block_list]{block_list()}}
\item \code{\link[=fpar]{fpar()}}
}}

\item{...}{Arguments to be passed to methods}
}
\value{
a string containing the RTF code
}
\description{
Convert an object made with package officer
to RTF.
}
\seealso{
Other functions for officer extensions: 
\code{\link{docx_reference_img}()},
\code{\link{fortify_location}()},
\code{\link{get_reference_value}()},
\code{\link{opts_current_table}()},
\code{\link{shape_properties_tags}()},
\code{\link{str_encode_to_rtf}()},
\code{\link{to_html}()},
\code{\link{to_pml}()},
\code{\link{to_wml}()},
\code{\link{wml_link_images}()}
}
\concept{functions for officer extensions}
\keyword{internal}
