% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xgboost.R
\name{xgb_train_offset}
\alias{xgb_train_offset}
\alias{xgb_predict_offset}
\title{Boosted Poisson Trees with Offsets via \code{xgboost}}
\usage{
xgb_train_offset(
  x,
  y,
  offset_col = "offset",
  weights = NULL,
  max_depth = 6,
  nrounds = 15,
  eta = 0.3,
  colsample_bynode = NULL,
  colsample_bytree = NULL,
  min_child_weight = 1,
  gamma = 0,
  subsample = 1,
  validation = 0,
  early_stop = NULL,
  counts = TRUE,
  ...
)

xgb_predict_offset(object, new_data, offset_col = "offset", ...)
}
\arguments{
\item{x}{A data frame or matrix of predictors}

\item{y}{A vector (numeric) or matrix (numeric) of outcome data.}

\item{offset_col}{Character string. The name of a column in \code{data} containing
offsets.}

\item{weights}{A numeric vector of weights.}

\item{max_depth}{An integer for the maximum depth of the tree.}

\item{nrounds}{An integer for the number of boosting iterations.}

\item{eta}{A numeric value between zero and one to control the learning rate.}

\item{colsample_bynode}{Subsampling proportion of columns for each node
within each tree. See the \code{counts} argument below. The default uses all
columns.}

\item{colsample_bytree}{Subsampling proportion of columns for each tree.
See the \code{counts} argument below. The default uses all columns.}

\item{min_child_weight}{A numeric value for the minimum sum of instance
weights needed in a child to continue to split.}

\item{gamma}{A number for the minimum loss reduction required to make a
further partition on a leaf node of the tree}

\item{subsample}{Subsampling proportion of rows. By default, all of the
training data are used.}

\item{validation}{The \emph{proportion} of the data that are used for performance
assessment and potential early stopping.}

\item{early_stop}{An integer or \code{NULL}. If not \code{NULL}, it is the number of
training iterations without improvement before stopping. If \code{validation} is
used, performance is base on the validation set; otherwise, the training set
is used.}

\item{counts}{A logical. If \code{FALSE}, \code{colsample_bynode} and
\code{colsample_bytree} are both assumed to be \emph{proportions} of the proportion of
columns affects (instead of counts).}

\item{...}{Other options to pass to \code{xgb.train()} or xgboost's method for \code{predict()}.}

\item{object}{An \code{xgboost} object.}

\item{new_data}{New data for predictions. Can be a data frame, matrix,
\code{xgb.DMatrix}}
}
\value{
A fitted \code{xgboost} object.
}
\description{
\code{xgb_train_offset()} and \code{xgb_predict_offset()} are wrappers for \code{xgboost}
tree-based models where all of the model arguments are in the main function.
These functions are nearly identical to the parsnip functions
\code{parsnip::xgb_train()} and \code{parsnip::xg_predict_offset()} except that the
objective "count:poisson" is passed to \code{xgboost::xgb.train()} and an offset
term is added to the data set.
}
\examples{
if (interactive()) {
  us_deaths$off <- log(us_deaths$population)
  x <- model.matrix(~ age_group + gender + off, us_deaths)[, -1]

  mod <- xgb_train_offset(x, us_deaths$deaths, "off",
                          eta = 1, colsample_bynode = 1,
                          max_depth = 2, nrounds = 25,
                          counts = FALSE)

  xgb_predict_offset(mod, x, "off")
}

}
