% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scrapers.R
\name{get_html_meta_from_article}
\alias{get_html_meta_from_article}
\title{Scraping metadata from the OJS articles HTML}
\usage{
get_html_meta_from_article(input_url, verbose = FALSE)
}
\arguments{
\item{input_url}{Character vector.}

\item{verbose}{Logical.}
}
\value{
A long-format dataframe with the url you provided (input_url), the name of the metadata (meta_data_name),
the content of the metadata (meta_data_content), the standard in which the content is annotated (meta_data_scheme),
and the language in which the metadata was entered (meta_data_xmllang)
}
\description{
Takes a vector of OJS URLs and scrapes all metadata written in HTML from the article view
}
\examples{
\donttest{
article <- 'https://dspace.palermo.edu/ojs/index.php/psicodebate/article/view/516/311'
metadata <- ojsr::get_html_meta_from_article(article)
}
}
