% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ols-stepaic-backward-regression.R
\name{ols_step_backward_sbic}
\alias{ols_step_backward_sbic}
\alias{ols_step_backward_sbic.default}
\alias{plot.ols_step_backward_sbic}
\title{Stepwise SBIC backward regression}
\usage{
ols_step_backward_sbic(model, ...)

\method{ols_step_backward_sbic}{default}(
  model,
  include = NULL,
  exclude = NULL,
  progress = FALSE,
  details = FALSE,
  ...
)

\method{plot}{ols_step_backward_sbic}(x, print_plot = TRUE, details = TRUE, digits = 3, ...)
}
\arguments{
\item{model}{An object of class \code{lm}; the model should include all
candidate predictor variables.}

\item{...}{Other arguments.}

\item{include}{Character or numeric vector; variables to be included in selection process.}

\item{exclude}{Character or numeric vector; variables to be excluded from selection process.}

\item{progress}{Logical; if \code{TRUE}, will display variable selection progress.}

\item{details}{Logical; if \code{TRUE}, will print the regression result at
each step.}

\item{x}{An object of class \code{ols_step_backward_*}.}

\item{print_plot}{logical; if \code{TRUE}, prints the plot else returns a plot object.}

\item{digits}{Number of decimal places to display.}
}
\value{
List containing the following components:

\item{model}{final model; an object of class \code{lm}}
\item{metrics}{selection metrics}
\item{others}{list; info used for plotting and printing}
}
\description{
Build regression model from a set of candidate predictor variables by
removing predictors based on sawa bayesian criterion, in a stepwise
manner until there is no variable left to remove any more.
}
\examples{
# stepwise backward regression
model <- lm(y ~ ., data = surgical)
ols_step_backward_sbic(model)

# stepwise backward regression plot
model <- lm(y ~ ., data = surgical)
k <- ols_step_backward_sbic(model)
plot(k)

# selection metrics
k$metrics

# final model
k$model

# include or exclude variable
# force variables to be included in the selection process
ols_step_backward_sbic(model, include = c("alc_mod", "gender"))

# use index of variable instead of name
ols_step_backward_sbic(model, include = c(7, 6))

# force variable to be excluded from selection process
ols_step_backward_sbic(model, exclude = c("alc_heavy", "bcs"))

# use index of variable instead of name
ols_step_backward_sbic(model, exclude = c(8, 1))

}
\references{
Venables, W. N. and Ripley, B. D. (2002) Modern Applied Statistics with S. Fourth edition. Springer.
}
\seealso{
Other backward selection procedures: 
\code{\link{ols_step_backward_adj_r2}()},
\code{\link{ols_step_backward_aic}()},
\code{\link{ols_step_backward_p}()},
\code{\link{ols_step_backward_r2}()},
\code{\link{ols_step_backward_sbc}()}
}
\concept{backward selection procedures}
