% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ols-best-subsets-regression.R
\name{ols_step_best_subset}
\alias{ols_step_best_subset}
\alias{ols_step_best_subset.default}
\alias{plot.ols_step_best_subset}
\title{Best subsets regression}
\usage{
ols_step_best_subset(model, ...)

\method{ols_step_best_subset}{default}(
  model,
  max_order = NULL,
  include = NULL,
  exclude = NULL,
  metric = c("rsquare", "adjr", "predrsq", "cp", "aic", "sbic", "sbc", "msep", "fpe",
    "apc", "hsp"),
  ...
)

\method{plot}{ols_step_best_subset}(x, model = NA, print_plot = TRUE, ...)
}
\arguments{
\item{model}{An object of class \code{lm}.}

\item{...}{Other inputs.}

\item{max_order}{Maximum subset order.}

\item{include}{Character or numeric vector; variables to be included in selection process.}

\item{exclude}{Character or numeric vector; variables to be excluded from selection process.}

\item{metric}{Metric to select model.}

\item{x}{An object of class \code{ols_step_best_subset}.}

\item{print_plot}{logical; if \code{TRUE}, prints the plot else returns a plot object.}
}
\value{
\code{ols_step_best_subset} returns an object of class \code{"ols_step_best_subset"}.
An object of class \code{"ols_step_best_subset"} is a list containing the following:

\item{metrics}{selection metrics}
}
\description{
Select the subset of predictors that do the best at meeting some
well-defined objective criterion, such as having the largest R2 value or the
smallest MSE, Mallow's Cp or AIC. The default metric used for selecting the
model is R2 but the user can choose any of the other available metrics.
}
\examples{
model <- lm(mpg ~ disp + hp + wt + qsec, data = mtcars)
ols_step_best_subset(model)
ols_step_best_subset(model, metric = "adjr")
ols_step_best_subset(model, metric = "cp")

# maximum subset
model <- lm(mpg ~ disp + hp + drat + wt + qsec, data = mtcars)
ols_step_best_subset(model, max_order = 3)

# plot
model <- lm(mpg ~ disp + hp + wt + qsec, data = mtcars)
k <- ols_step_best_subset(model)
plot(k)

# return only models including `qsec`
ols_step_best_subset(model, include = c("qsec"))

# exclude `hp` from selection process
ols_step_best_subset(model, exclude = c("hp"))

}
\references{
Kutner, MH, Nachtscheim CJ, Neter J and Li W., 2004, Applied Linear Statistical Models (5th edition).
Chicago, IL., McGraw Hill/Irwin.
}
