# output from stepAIC forward regression is as expected

    Code
      ols_step_forward_aic(model)
    Output
      
      
                                    Stepwise Summary                              
      --------------------------------------------------------------------------
      Step    Variable         AIC        SBC       SBIC        R2       Adj. R2 
      --------------------------------------------------------------------------
       0      Base Model     802.606    806.584    646.794    0.00000    0.00000 
       1      liver_test     771.875    777.842    616.009    0.45454    0.44405 
       2      alc_heavy      761.439    769.395    605.506    0.56674    0.54975 
       3      enzyme_test    750.509    760.454    595.297    0.65900    0.63854 
       4      pindex         735.715    747.649    582.943    0.75015    0.72975 
       5      bcs            730.620    744.543    579.638    0.78091    0.75808 
      --------------------------------------------------------------------------
      
      Final Model Output 
      ------------------
      
                                 Model Summary                            
      -------------------------------------------------------------------
      R                         0.884       RMSE                 184.276 
      R-Squared                 0.781       MSE                33957.712 
      Adj. R-Squared            0.758       Coef. Var             27.839 
      Pred R-Squared            0.700       AIC                  730.620 
      MAE                     137.656       SBC                  744.543 
      -------------------------------------------------------------------
       RMSE: Root Mean Square Error 
       MSE: Mean Square Error 
       MAE: Mean Absolute Error 
       AIC: Akaike Information Criteria 
       SBC: Schwarz Bayesian Criteria 
      
                                       ANOVA                                  
      -----------------------------------------------------------------------
                         Sum of                                              
                        Squares        DF    Mean Square      F         Sig. 
      -----------------------------------------------------------------------
      Regression    6535804.090         5    1307160.818    34.217    0.0000 
      Residual      1833716.447        48      38202.426                     
      Total         8369520.537        53                                    
      -----------------------------------------------------------------------
      
                                            Parameter Estimates                                        
      ------------------------------------------------------------------------------------------------
            model         Beta    Std. Error    Std. Beta      t        Sig         lower       upper 
      ------------------------------------------------------------------------------------------------
      (Intercept)    -1178.330       208.682                 -5.647    0.000    -1597.914    -758.746 
       liver_test       58.064        40.144        0.156     1.446    0.155      -22.652     138.779 
        alc_heavy      317.848        71.634        0.314     4.437    0.000      173.818     461.878 
      enzyme_test        9.748         1.656        0.521     5.887    0.000        6.419      13.077 
           pindex        8.924         1.808        0.380     4.935    0.000        5.288      12.559 
              bcs       59.864        23.060        0.241     2.596    0.012       13.498     106.230 
      ------------------------------------------------------------------------------------------------
      

---

    Code
      ols_step_forward_aic(model, progress = TRUE)
    Output
      Forward Selection Method 
      ------------------------
      
      Candidate Terms: 
      
      1. bcs 
      2. pindex 
      3. enzyme_test 
      4. liver_test 
      5. age 
      6. gender 
      7. alc_mod 
      8. alc_heavy 
      
      
      Variables Entered: 
      
      => liver_test 
      => alc_heavy 
      => enzyme_test 
      => pindex 
      => bcs 
      
      No more variables to be added.
      
      
                                    Stepwise Summary                              
      --------------------------------------------------------------------------
      Step    Variable         AIC        SBC       SBIC        R2       Adj. R2 
      --------------------------------------------------------------------------
       0      Base Model     802.606    806.584    646.794    0.00000    0.00000 
       1      liver_test     771.875    777.842    616.009    0.45454    0.44405 
       2      alc_heavy      761.439    769.395    605.506    0.56674    0.54975 
       3      enzyme_test    750.509    760.454    595.297    0.65900    0.63854 
       4      pindex         735.715    747.649    582.943    0.75015    0.72975 
       5      bcs            730.620    744.543    579.638    0.78091    0.75808 
      --------------------------------------------------------------------------
      
      Final Model Output 
      ------------------
      
                                 Model Summary                            
      -------------------------------------------------------------------
      R                         0.884       RMSE                 184.276 
      R-Squared                 0.781       MSE                33957.712 
      Adj. R-Squared            0.758       Coef. Var             27.839 
      Pred R-Squared            0.700       AIC                  730.620 
      MAE                     137.656       SBC                  744.543 
      -------------------------------------------------------------------
       RMSE: Root Mean Square Error 
       MSE: Mean Square Error 
       MAE: Mean Absolute Error 
       AIC: Akaike Information Criteria 
       SBC: Schwarz Bayesian Criteria 
      
                                       ANOVA                                  
      -----------------------------------------------------------------------
                         Sum of                                              
                        Squares        DF    Mean Square      F         Sig. 
      -----------------------------------------------------------------------
      Regression    6535804.090         5    1307160.818    34.217    0.0000 
      Residual      1833716.447        48      38202.426                     
      Total         8369520.537        53                                    
      -----------------------------------------------------------------------
      
                                            Parameter Estimates                                        
      ------------------------------------------------------------------------------------------------
            model         Beta    Std. Error    Std. Beta      t        Sig         lower       upper 
      ------------------------------------------------------------------------------------------------
      (Intercept)    -1178.330       208.682                 -5.647    0.000    -1597.914    -758.746 
       liver_test       58.064        40.144        0.156     1.446    0.155      -22.652     138.779 
        alc_heavy      317.848        71.634        0.314     4.437    0.000      173.818     461.878 
      enzyme_test        9.748         1.656        0.521     5.887    0.000        6.419      13.077 
           pindex        8.924         1.808        0.380     4.935    0.000        5.288      12.559 
              bcs       59.864        23.060        0.241     2.596    0.012       13.498     106.230 
      ------------------------------------------------------------------------------------------------
      

---

    Code
      ols_step_forward_aic(model, details = TRUE)
    Output
      Forward Selection Method 
      ------------------------
      
      Candidate Terms: 
      
      1. bcs 
      2. pindex 
      3. enzyme_test 
      4. liver_test 
      5. age 
      6. gender 
      7. alc_mod 
      8. alc_heavy 
      
      
      Step     => 0 
      Model    => y ~ 1 
      AIC      => 802.606 
      
      Initiating stepwise selection... 
      
                             Table: Adding New Variables                        
      -------------------------------------------------------------------------
      Predictor      DF      AIC        SBC       SBIC        R2       Adj. R2  
      -------------------------------------------------------------------------
      liver_test      1    771.875    777.842    616.009    0.45454     0.44405 
      enzyme_test     1    782.629    788.596    626.220    0.33435     0.32154 
      pindex          1    794.100    800.067    637.196    0.17680     0.16097 
      alc_heavy       1    794.301    800.268    637.389    0.17373     0.15784 
      bcs             1    797.697    803.664    640.655    0.12010     0.10318 
      alc_mod         1    802.828    808.795    645.601    0.03239     0.01378 
      gender          1    802.956    808.923    645.725    0.03009     0.01143 
      age             1    803.834    809.801    646.572    0.01420    -0.00476 
      -------------------------------------------------------------------------
      
      Step     => 1 
      Added    => liver_test 
      Model    => y ~ liver_test 
      AIC      => 771.8753 
      
                            Table: Adding New Variables                        
      ------------------------------------------------------------------------
      Predictor      DF      AIC        SBC       SBIC        R2       Adj. R2 
      ------------------------------------------------------------------------
      alc_heavy       1    761.439    769.395    605.506    0.56674    0.54975 
      enzyme_test     1    762.077    770.033    606.090    0.56159    0.54440 
      pindex          1    770.387    778.343    613.737    0.48866    0.46861 
      alc_mod         1    771.141    779.097    614.435    0.48147    0.46113 
      gender          1    773.802    781.758    616.901    0.45528    0.43391 
      age             1    773.831    781.787    616.928    0.45498    0.43361 
      bcs             1    773.867    781.823    616.961    0.45462    0.43323 
      ------------------------------------------------------------------------
      
      Step     => 2 
      Added    => alc_heavy 
      Model    => y ~ liver_test + alc_heavy 
      AIC      => 761.4394 
      
                            Table: Adding New Variables                        
      ------------------------------------------------------------------------
      Predictor      DF      AIC        SBC       SBIC        R2       Adj. R2 
      ------------------------------------------------------------------------
      enzyme_test     1    750.509    760.454    595.297    0.65900    0.63854 
      pindex          1    756.125    766.070    600.225    0.62163    0.59892 
      bcs             1    763.063    773.008    606.379    0.56975    0.54394 
      age             1    763.110    773.055    606.421    0.56938    0.54354 
      alc_mod         1    763.428    773.373    606.704    0.56683    0.54084 
      gender          1    763.433    773.378    606.709    0.56679    0.54080 
      ------------------------------------------------------------------------
      
      Step     => 3 
      Added    => enzyme_test 
      Model    => y ~ liver_test + alc_heavy + enzyme_test 
      AIC      => 750.5089 
      
                           Table: Adding New Variables                       
      ----------------------------------------------------------------------
      Predictor    DF      AIC        SBC       SBIC        R2       Adj. R2 
      ----------------------------------------------------------------------
      pindex        1    735.715    747.649    582.943    0.75015    0.72975 
      bcs           1    750.782    762.716    595.377    0.66973    0.64277 
      alc_mod       1    752.403    764.337    596.743    0.65967    0.63189 
      age           1    752.416    764.350    596.755    0.65959    0.63180 
      gender        1    752.509    764.443    596.833    0.65900    0.63116 
      ----------------------------------------------------------------------
      
      Step     => 4 
      Added    => pindex 
      Model    => y ~ liver_test + alc_heavy + enzyme_test + pindex 
      AIC      => 735.7146 
      
                           Table: Adding New Variables                       
      ----------------------------------------------------------------------
      Predictor    DF      AIC        SBC       SBIC        R2       Adj. R2 
      ----------------------------------------------------------------------
      bcs           1    730.620    744.543    579.638    0.78091    0.75808 
      age           1    737.680    751.603    585.012    0.75030    0.72429 
      gender        1    737.712    751.635    585.036    0.75016    0.72413 
      alc_mod       1    737.713    751.636    585.037    0.75015    0.72413 
      ----------------------------------------------------------------------
      
      Step     => 5 
      Added    => bcs 
      Model    => y ~ liver_test + alc_heavy + enzyme_test + pindex + bcs 
      AIC      => 730.6204 
      
                           Table: Adding New Variables                       
      ----------------------------------------------------------------------
      Predictor    DF      AIC        SBC       SBIC        R2       Adj. R2 
      ----------------------------------------------------------------------
      age           1    732.494    748.406    581.938    0.78142    0.75351 
      gender        1    732.551    748.463    581.978    0.78119    0.75325 
      alc_mod       1    732.614    748.526    582.023    0.78093    0.75297 
      ----------------------------------------------------------------------
      
      
      No more variables to be added.
      
      Variables Selected: 
      
      => liver_test 
      => alc_heavy 
      => enzyme_test 
      => pindex 
      => bcs 
      
      
                                    Stepwise Summary                              
      --------------------------------------------------------------------------
      Step    Variable         AIC        SBC       SBIC        R2       Adj. R2 
      --------------------------------------------------------------------------
       0      Base Model     802.606    806.584    646.794    0.00000    0.00000 
       1      liver_test     771.875    777.842    616.009    0.45454    0.44405 
       2      alc_heavy      761.439    769.395    605.506    0.56674    0.54975 
       3      enzyme_test    750.509    760.454    595.297    0.65900    0.63854 
       4      pindex         735.715    747.649    582.943    0.75015    0.72975 
       5      bcs            730.620    744.543    579.638    0.78091    0.75808 
      --------------------------------------------------------------------------
      
      Final Model Output 
      ------------------
      
                                 Model Summary                            
      -------------------------------------------------------------------
      R                         0.884       RMSE                 184.276 
      R-Squared                 0.781       MSE                33957.712 
      Adj. R-Squared            0.758       Coef. Var             27.839 
      Pred R-Squared            0.700       AIC                  730.620 
      MAE                     137.656       SBC                  744.543 
      -------------------------------------------------------------------
       RMSE: Root Mean Square Error 
       MSE: Mean Square Error 
       MAE: Mean Absolute Error 
       AIC: Akaike Information Criteria 
       SBC: Schwarz Bayesian Criteria 
      
                                       ANOVA                                  
      -----------------------------------------------------------------------
                         Sum of                                              
                        Squares        DF    Mean Square      F         Sig. 
      -----------------------------------------------------------------------
      Regression    6535804.090         5    1307160.818    34.217    0.0000 
      Residual      1833716.447        48      38202.426                     
      Total         8369520.537        53                                    
      -----------------------------------------------------------------------
      
                                            Parameter Estimates                                        
      ------------------------------------------------------------------------------------------------
            model         Beta    Std. Error    Std. Beta      t        Sig         lower       upper 
      ------------------------------------------------------------------------------------------------
      (Intercept)    -1178.330       208.682                 -5.647    0.000    -1597.914    -758.746 
       liver_test       58.064        40.144        0.156     1.446    0.155      -22.652     138.779 
        alc_heavy      317.848        71.634        0.314     4.437    0.000      173.818     461.878 
      enzyme_test        9.748         1.656        0.521     5.887    0.000        6.419      13.077 
           pindex        8.924         1.808        0.380     4.935    0.000        5.288      12.559 
              bcs       59.864        23.060        0.241     2.596    0.012       13.498     106.230 
      ------------------------------------------------------------------------------------------------
      

---

    Code
      ols_step_forward_aic(model, include = "pindex", details = TRUE)
    Output
      Forward Selection Method 
      ------------------------
      
      Candidate Terms: 
      
      1. bcs 
      2. enzyme_test 
      3. liver_test 
      4. age 
      5. gender 
      6. alc_mod 
      7. alc_heavy 
      
      
      Step     => 0 
      Model    => y ~ pindex 
      AIC      => 794.0997 
      
      Initiating stepwise selection... 
      
                            Table: Adding New Variables                        
      ------------------------------------------------------------------------
      Predictor      DF      AIC        SBC       SBIC        R2       Adj. R2 
      ------------------------------------------------------------------------
      enzyme_test     1    766.642    774.598    610.282    0.52292    0.50421 
      liver_test      1    770.387    778.343    613.737    0.48866    0.46861 
      alc_heavy       1    780.568    788.524    623.203    0.38256    0.35835 
      bcs             1    789.400    797.356    631.496    0.27285    0.24434 
      alc_mod         1    792.349    800.305    634.280    0.23204    0.20192 
      gender          1    795.111    803.067    636.895    0.19174    0.16004 
      age             1    795.450    803.406    637.216    0.18665    0.15476 
      ------------------------------------------------------------------------
      
      Step     => 1 
      Added    => enzyme_test 
      Model    => y ~ pindex + enzyme_test 
      AIC      => 766.6422 
      
                            Table: Adding New Variables                       
      -----------------------------------------------------------------------
      Predictor     DF      AIC        SBC       SBIC        R2       Adj. R2 
      -----------------------------------------------------------------------
      bcs            1    746.376    756.320    591.702    0.68413    0.66518 
      alc_heavy      1    748.167    758.112    593.257    0.67347    0.65388 
      liver_test     1    755.099    765.044    599.321    0.62875    0.60647 
      alc_mod        1    764.533    774.477    607.692    0.55788    0.53135 
      age            1    767.697    777.642    610.529    0.53120    0.50307 
      gender         1    768.479    778.424    611.232    0.52436    0.49582 
      -----------------------------------------------------------------------
      
      Step     => 2 
      Added    => bcs 
      Model    => y ~ pindex + enzyme_test + bcs 
      AIC      => 746.3755 
      
                            Table: Adding New Variables                       
      -----------------------------------------------------------------------
      Predictor     DF      AIC        SBC       SBIC        R2       Adj. R2 
      -----------------------------------------------------------------------
      alc_heavy      1    730.924    742.858    579.087    0.77136    0.75269 
      alc_mod        1    744.985    756.919    590.537    0.70335    0.67913 
      age            1    747.171    759.105    592.354    0.69109    0.66588 
      liver_test     1    747.181    759.114    592.362    0.69104    0.66582 
      gender         1    748.330    760.264    593.322    0.68439    0.65863 
      -----------------------------------------------------------------------
      
      Step     => 3 
      Added    => alc_heavy 
      Model    => y ~ pindex + enzyme_test + bcs + alc_heavy 
      AIC      => 730.9241 
      
                            Table: Adding New Variables                       
      -----------------------------------------------------------------------
      Predictor     DF      AIC        SBC       SBIC        R2       Adj. R2 
      -----------------------------------------------------------------------
      liver_test     1    730.620    744.543    579.638    0.78091    0.75808 
      age            1    732.339    746.262    580.934    0.77382    0.75026 
      gender         1    732.516    746.439    581.067    0.77308    0.74944 
      alc_mod        1    732.909    746.832    581.365    0.77142    0.74761 
      -----------------------------------------------------------------------
      
      Step     => 4 
      Added    => liver_test 
      Model    => y ~ pindex + enzyme_test + bcs + alc_heavy + liver_test 
      AIC      => 730.6204 
      
                           Table: Adding New Variables                       
      ----------------------------------------------------------------------
      Predictor    DF      AIC        SBC       SBIC        R2       Adj. R2 
      ----------------------------------------------------------------------
      age           1    732.494    748.406    581.938    0.78142    0.75351 
      gender        1    732.551    748.463    581.978    0.78119    0.75325 
      alc_mod       1    732.614    748.526    582.023    0.78093    0.75297 
      ----------------------------------------------------------------------
      
      
      No more variables to be added.
      
      Variables Selected: 
      
      => pindex 
      => enzyme_test 
      => bcs 
      => alc_heavy 
      => liver_test 
      
      
                                    Stepwise Summary                              
      --------------------------------------------------------------------------
      Step    Variable         AIC        SBC       SBIC        R2       Adj. R2 
      --------------------------------------------------------------------------
       0      Base Model     794.100    800.067    637.196    0.17680    0.16097 
       1      enzyme_test    766.642    774.598    610.282    0.52292    0.50421 
       2      bcs            746.376    756.320    591.702    0.68413    0.66518 
       3      alc_heavy      730.924    742.858    579.087    0.77136    0.75269 
       4      liver_test     730.620    744.543    579.638    0.78091    0.75808 
      --------------------------------------------------------------------------
      
      Final Model Output 
      ------------------
      
                                 Model Summary                            
      -------------------------------------------------------------------
      R                         0.884       RMSE                 184.276 
      R-Squared                 0.781       MSE                33957.712 
      Adj. R-Squared            0.758       Coef. Var             27.839 
      Pred R-Squared            0.700       AIC                  730.620 
      MAE                     137.656       SBC                  744.543 
      -------------------------------------------------------------------
       RMSE: Root Mean Square Error 
       MSE: Mean Square Error 
       MAE: Mean Absolute Error 
       AIC: Akaike Information Criteria 
       SBC: Schwarz Bayesian Criteria 
      
                                       ANOVA                                  
      -----------------------------------------------------------------------
                         Sum of                                              
                        Squares        DF    Mean Square      F         Sig. 
      -----------------------------------------------------------------------
      Regression    6535804.090         5    1307160.818    34.217    0.0000 
      Residual      1833716.447        48      38202.426                     
      Total         8369520.537        53                                    
      -----------------------------------------------------------------------
      
                                            Parameter Estimates                                        
      ------------------------------------------------------------------------------------------------
            model         Beta    Std. Error    Std. Beta      t        Sig         lower       upper 
      ------------------------------------------------------------------------------------------------
      (Intercept)    -1178.330       208.682                 -5.647    0.000    -1597.914    -758.746 
           pindex        8.924         1.808        0.380     4.935    0.000        5.288      12.559 
      enzyme_test        9.748         1.656        0.521     5.887    0.000        6.419      13.077 
              bcs       59.864        23.060        0.241     2.596    0.012       13.498     106.230 
        alc_heavy      317.848        71.634        0.314     4.437    0.000      173.818     461.878 
       liver_test       58.064        40.144        0.156     1.446    0.155      -22.652     138.779 
      ------------------------------------------------------------------------------------------------
      

# output from stepSBC forward regression is as expected

    Code
      ols_step_forward_sbc(model)
    Output
      
      
                                    Stepwise Summary                              
      --------------------------------------------------------------------------
      Step    Variable         AIC        SBC       SBIC        R2       Adj. R2 
      --------------------------------------------------------------------------
       0      Base Model     802.606    806.584    646.794    0.00000    0.00000 
       1      liver_test     771.875    777.842    616.009    0.45454    0.44405 
       2      alc_heavy      761.439    769.395    605.506    0.56674    0.54975 
       3      enzyme_test    750.509    760.454    595.297    0.65900    0.63854 
       4      pindex         735.715    747.649    582.943    0.75015    0.72975 
       5      bcs            730.620    744.543    579.638    0.78091    0.75808 
      --------------------------------------------------------------------------
      
      Final Model Output 
      ------------------
      
                                 Model Summary                            
      -------------------------------------------------------------------
      R                         0.884       RMSE                 184.276 
      R-Squared                 0.781       MSE                33957.712 
      Adj. R-Squared            0.758       Coef. Var             27.839 
      Pred R-Squared            0.700       AIC                  730.620 
      MAE                     137.656       SBC                  744.543 
      -------------------------------------------------------------------
       RMSE: Root Mean Square Error 
       MSE: Mean Square Error 
       MAE: Mean Absolute Error 
       AIC: Akaike Information Criteria 
       SBC: Schwarz Bayesian Criteria 
      
                                       ANOVA                                  
      -----------------------------------------------------------------------
                         Sum of                                              
                        Squares        DF    Mean Square      F         Sig. 
      -----------------------------------------------------------------------
      Regression    6535804.090         5    1307160.818    34.217    0.0000 
      Residual      1833716.447        48      38202.426                     
      Total         8369520.537        53                                    
      -----------------------------------------------------------------------
      
                                            Parameter Estimates                                        
      ------------------------------------------------------------------------------------------------
            model         Beta    Std. Error    Std. Beta      t        Sig         lower       upper 
      ------------------------------------------------------------------------------------------------
      (Intercept)    -1178.330       208.682                 -5.647    0.000    -1597.914    -758.746 
       liver_test       58.064        40.144        0.156     1.446    0.155      -22.652     138.779 
        alc_heavy      317.848        71.634        0.314     4.437    0.000      173.818     461.878 
      enzyme_test        9.748         1.656        0.521     5.887    0.000        6.419      13.077 
           pindex        8.924         1.808        0.380     4.935    0.000        5.288      12.559 
              bcs       59.864        23.060        0.241     2.596    0.012       13.498     106.230 
      ------------------------------------------------------------------------------------------------
      

---

    Code
      ols_step_forward_sbc(model, progress = TRUE)
    Output
      Forward Selection Method 
      ------------------------
      
      Candidate Terms: 
      
      1. bcs 
      2. pindex 
      3. enzyme_test 
      4. liver_test 
      5. age 
      6. gender 
      7. alc_mod 
      8. alc_heavy 
      
      
      Variables Entered: 
      
      => liver_test 
      => alc_heavy 
      => enzyme_test 
      => pindex 
      => bcs 
      
      No more variables to be added.
      
      
                                    Stepwise Summary                              
      --------------------------------------------------------------------------
      Step    Variable         AIC        SBC       SBIC        R2       Adj. R2 
      --------------------------------------------------------------------------
       0      Base Model     802.606    806.584    646.794    0.00000    0.00000 
       1      liver_test     771.875    777.842    616.009    0.45454    0.44405 
       2      alc_heavy      761.439    769.395    605.506    0.56674    0.54975 
       3      enzyme_test    750.509    760.454    595.297    0.65900    0.63854 
       4      pindex         735.715    747.649    582.943    0.75015    0.72975 
       5      bcs            730.620    744.543    579.638    0.78091    0.75808 
      --------------------------------------------------------------------------
      
      Final Model Output 
      ------------------
      
                                 Model Summary                            
      -------------------------------------------------------------------
      R                         0.884       RMSE                 184.276 
      R-Squared                 0.781       MSE                33957.712 
      Adj. R-Squared            0.758       Coef. Var             27.839 
      Pred R-Squared            0.700       AIC                  730.620 
      MAE                     137.656       SBC                  744.543 
      -------------------------------------------------------------------
       RMSE: Root Mean Square Error 
       MSE: Mean Square Error 
       MAE: Mean Absolute Error 
       AIC: Akaike Information Criteria 
       SBC: Schwarz Bayesian Criteria 
      
                                       ANOVA                                  
      -----------------------------------------------------------------------
                         Sum of                                              
                        Squares        DF    Mean Square      F         Sig. 
      -----------------------------------------------------------------------
      Regression    6535804.090         5    1307160.818    34.217    0.0000 
      Residual      1833716.447        48      38202.426                     
      Total         8369520.537        53                                    
      -----------------------------------------------------------------------
      
                                            Parameter Estimates                                        
      ------------------------------------------------------------------------------------------------
            model         Beta    Std. Error    Std. Beta      t        Sig         lower       upper 
      ------------------------------------------------------------------------------------------------
      (Intercept)    -1178.330       208.682                 -5.647    0.000    -1597.914    -758.746 
       liver_test       58.064        40.144        0.156     1.446    0.155      -22.652     138.779 
        alc_heavy      317.848        71.634        0.314     4.437    0.000      173.818     461.878 
      enzyme_test        9.748         1.656        0.521     5.887    0.000        6.419      13.077 
           pindex        8.924         1.808        0.380     4.935    0.000        5.288      12.559 
              bcs       59.864        23.060        0.241     2.596    0.012       13.498     106.230 
      ------------------------------------------------------------------------------------------------
      

---

    Code
      ols_step_forward_sbc(model, details = TRUE)
    Output
      Forward Selection Method 
      ------------------------
      
      Candidate Terms: 
      
      1. bcs 
      2. pindex 
      3. enzyme_test 
      4. liver_test 
      5. age 
      6. gender 
      7. alc_mod 
      8. alc_heavy 
      
      
      Step     => 0 
      Model    => y ~ 1 
      SBC      => 806.584 
      
      Initiating stepwise selection... 
      
                             Table: Adding New Variables                        
      -------------------------------------------------------------------------
      Predictor      DF      AIC        SBC       SBIC        R2       Adj. R2  
      -------------------------------------------------------------------------
      liver_test      1    771.875    777.842    616.009    0.45454     0.44405 
      enzyme_test     1    782.629    788.596    626.220    0.33435     0.32154 
      pindex          1    794.100    800.067    637.196    0.17680     0.16097 
      alc_heavy       1    794.301    800.268    637.389    0.17373     0.15784 
      bcs             1    797.697    803.664    640.655    0.12010     0.10318 
      alc_mod         1    802.828    808.795    645.601    0.03239     0.01378 
      gender          1    802.956    808.923    645.725    0.03009     0.01143 
      age             1    803.834    809.801    646.572    0.01420    -0.00476 
      -------------------------------------------------------------------------
      
      Step     => 1 
      Added    => liver_test 
      Model    => y ~ liver_test 
      SBC      => 777.8423 
      
                            Table: Adding New Variables                        
      ------------------------------------------------------------------------
      Predictor      DF      AIC        SBC       SBIC        R2       Adj. R2 
      ------------------------------------------------------------------------
      alc_heavy       1    761.439    769.395    605.506    0.56674    0.54975 
      enzyme_test     1    762.077    770.033    606.090    0.56159    0.54440 
      pindex          1    770.387    778.343    613.737    0.48866    0.46861 
      alc_mod         1    771.141    779.097    614.435    0.48147    0.46113 
      gender          1    773.802    781.758    616.901    0.45528    0.43391 
      age             1    773.831    781.787    616.928    0.45498    0.43361 
      bcs             1    773.867    781.823    616.961    0.45462    0.43323 
      ------------------------------------------------------------------------
      
      Step     => 2 
      Added    => alc_heavy 
      Model    => y ~ liver_test + alc_heavy 
      SBC      => 769.3953 
      
                            Table: Adding New Variables                        
      ------------------------------------------------------------------------
      Predictor      DF      AIC        SBC       SBIC        R2       Adj. R2 
      ------------------------------------------------------------------------
      enzyme_test     1    750.509    760.454    595.297    0.65900    0.63854 
      pindex          1    756.125    766.070    600.225    0.62163    0.59892 
      bcs             1    763.063    773.008    606.379    0.56975    0.54394 
      age             1    763.110    773.055    606.421    0.56938    0.54354 
      alc_mod         1    763.428    773.373    606.704    0.56683    0.54084 
      gender          1    763.433    773.378    606.709    0.56679    0.54080 
      ------------------------------------------------------------------------
      
      Step     => 3 
      Added    => enzyme_test 
      Model    => y ~ liver_test + alc_heavy + enzyme_test 
      SBC      => 760.4538 
      
                           Table: Adding New Variables                       
      ----------------------------------------------------------------------
      Predictor    DF      AIC        SBC       SBIC        R2       Adj. R2 
      ----------------------------------------------------------------------
      pindex        1    735.715    747.649    582.943    0.75015    0.72975 
      bcs           1    750.782    762.716    595.377    0.66973    0.64277 
      alc_mod       1    752.403    764.337    596.743    0.65967    0.63189 
      age           1    752.416    764.350    596.755    0.65959    0.63180 
      gender        1    752.509    764.443    596.833    0.65900    0.63116 
      ----------------------------------------------------------------------
      
      Step     => 4 
      Added    => pindex 
      Model    => y ~ liver_test + alc_heavy + enzyme_test + pindex 
      SBC      => 747.6485 
      
                           Table: Adding New Variables                       
      ----------------------------------------------------------------------
      Predictor    DF      AIC        SBC       SBIC        R2       Adj. R2 
      ----------------------------------------------------------------------
      bcs           1    730.620    744.543    579.638    0.78091    0.75808 
      age           1    737.680    751.603    585.012    0.75030    0.72429 
      gender        1    737.712    751.635    585.036    0.75016    0.72413 
      alc_mod       1    737.713    751.636    585.037    0.75015    0.72413 
      ----------------------------------------------------------------------
      
      Step     => 5 
      Added    => bcs 
      Model    => y ~ liver_test + alc_heavy + enzyme_test + pindex + bcs 
      SBC      => 744.5433 
      
                           Table: Adding New Variables                       
      ----------------------------------------------------------------------
      Predictor    DF      AIC        SBC       SBIC        R2       Adj. R2 
      ----------------------------------------------------------------------
      age           1    732.494    748.406    581.938    0.78142    0.75351 
      gender        1    732.551    748.463    581.978    0.78119    0.75325 
      alc_mod       1    732.614    748.526    582.023    0.78093    0.75297 
      ----------------------------------------------------------------------
      
      
      No more variables to be added.
      
      Variables Selected: 
      
      => liver_test 
      => alc_heavy 
      => enzyme_test 
      => pindex 
      => bcs 
      
      
                                    Stepwise Summary                              
      --------------------------------------------------------------------------
      Step    Variable         AIC        SBC       SBIC        R2       Adj. R2 
      --------------------------------------------------------------------------
       0      Base Model     802.606    806.584    646.794    0.00000    0.00000 
       1      liver_test     771.875    777.842    616.009    0.45454    0.44405 
       2      alc_heavy      761.439    769.395    605.506    0.56674    0.54975 
       3      enzyme_test    750.509    760.454    595.297    0.65900    0.63854 
       4      pindex         735.715    747.649    582.943    0.75015    0.72975 
       5      bcs            730.620    744.543    579.638    0.78091    0.75808 
      --------------------------------------------------------------------------
      
      Final Model Output 
      ------------------
      
                                 Model Summary                            
      -------------------------------------------------------------------
      R                         0.884       RMSE                 184.276 
      R-Squared                 0.781       MSE                33957.712 
      Adj. R-Squared            0.758       Coef. Var             27.839 
      Pred R-Squared            0.700       AIC                  730.620 
      MAE                     137.656       SBC                  744.543 
      -------------------------------------------------------------------
       RMSE: Root Mean Square Error 
       MSE: Mean Square Error 
       MAE: Mean Absolute Error 
       AIC: Akaike Information Criteria 
       SBC: Schwarz Bayesian Criteria 
      
                                       ANOVA                                  
      -----------------------------------------------------------------------
                         Sum of                                              
                        Squares        DF    Mean Square      F         Sig. 
      -----------------------------------------------------------------------
      Regression    6535804.090         5    1307160.818    34.217    0.0000 
      Residual      1833716.447        48      38202.426                     
      Total         8369520.537        53                                    
      -----------------------------------------------------------------------
      
                                            Parameter Estimates                                        
      ------------------------------------------------------------------------------------------------
            model         Beta    Std. Error    Std. Beta      t        Sig         lower       upper 
      ------------------------------------------------------------------------------------------------
      (Intercept)    -1178.330       208.682                 -5.647    0.000    -1597.914    -758.746 
       liver_test       58.064        40.144        0.156     1.446    0.155      -22.652     138.779 
        alc_heavy      317.848        71.634        0.314     4.437    0.000      173.818     461.878 
      enzyme_test        9.748         1.656        0.521     5.887    0.000        6.419      13.077 
           pindex        8.924         1.808        0.380     4.935    0.000        5.288      12.559 
              bcs       59.864        23.060        0.241     2.596    0.012       13.498     106.230 
      ------------------------------------------------------------------------------------------------
      

---

    Code
      ols_step_forward_sbc(model, include = "pindex", details = TRUE)
    Output
      Forward Selection Method 
      ------------------------
      
      Candidate Terms: 
      
      1. bcs 
      2. enzyme_test 
      3. liver_test 
      4. age 
      5. gender 
      6. alc_mod 
      7. alc_heavy 
      
      
      Step     => 0 
      Model    => y ~ pindex 
      SBC      => 800.0667 
      
      Initiating stepwise selection... 
      
                            Table: Adding New Variables                        
      ------------------------------------------------------------------------
      Predictor      DF      AIC        SBC       SBIC        R2       Adj. R2 
      ------------------------------------------------------------------------
      enzyme_test     1    766.642    774.598    610.282    0.52292    0.50421 
      liver_test      1    770.387    778.343    613.737    0.48866    0.46861 
      alc_heavy       1    780.568    788.524    623.203    0.38256    0.35835 
      bcs             1    789.400    797.356    631.496    0.27285    0.24434 
      alc_mod         1    792.349    800.305    634.280    0.23204    0.20192 
      gender          1    795.111    803.067    636.895    0.19174    0.16004 
      age             1    795.450    803.406    637.216    0.18665    0.15476 
      ------------------------------------------------------------------------
      
      Step     => 1 
      Added    => enzyme_test 
      Model    => y ~ pindex + enzyme_test 
      SBC      => 774.5982 
      
                            Table: Adding New Variables                       
      -----------------------------------------------------------------------
      Predictor     DF      AIC        SBC       SBIC        R2       Adj. R2 
      -----------------------------------------------------------------------
      bcs            1    746.376    756.320    591.702    0.68413    0.66518 
      alc_heavy      1    748.167    758.112    593.257    0.67347    0.65388 
      liver_test     1    755.099    765.044    599.321    0.62875    0.60647 
      alc_mod        1    764.533    774.477    607.692    0.55788    0.53135 
      age            1    767.697    777.642    610.529    0.53120    0.50307 
      gender         1    768.479    778.424    611.232    0.52436    0.49582 
      -----------------------------------------------------------------------
      
      Step     => 2 
      Added    => bcs 
      Model    => y ~ pindex + enzyme_test + bcs 
      SBC      => 756.3204 
      
                            Table: Adding New Variables                       
      -----------------------------------------------------------------------
      Predictor     DF      AIC        SBC       SBIC        R2       Adj. R2 
      -----------------------------------------------------------------------
      alc_heavy      1    730.924    742.858    579.087    0.77136    0.75269 
      alc_mod        1    744.985    756.919    590.537    0.70335    0.67913 
      age            1    747.171    759.105    592.354    0.69109    0.66588 
      liver_test     1    747.181    759.114    592.362    0.69104    0.66582 
      gender         1    748.330    760.264    593.322    0.68439    0.65863 
      -----------------------------------------------------------------------
      
      Step     => 3 
      Added    => alc_heavy 
      Model    => y ~ pindex + enzyme_test + bcs + alc_heavy 
      SBC      => 742.858 
      
                            Table: Adding New Variables                       
      -----------------------------------------------------------------------
      Predictor     DF      AIC        SBC       SBIC        R2       Adj. R2 
      -----------------------------------------------------------------------
      liver_test     1    730.620    744.543    579.638    0.78091    0.75808 
      age            1    732.339    746.262    580.934    0.77382    0.75026 
      gender         1    732.516    746.439    581.067    0.77308    0.74944 
      alc_mod        1    732.909    746.832    581.365    0.77142    0.74761 
      -----------------------------------------------------------------------
      
      
      No more variables to be added.
      
      Variables Selected: 
      
      => pindex 
      => enzyme_test 
      => bcs 
      => alc_heavy 
      
      
                                    Stepwise Summary                              
      --------------------------------------------------------------------------
      Step    Variable         AIC        SBC       SBIC        R2       Adj. R2 
      --------------------------------------------------------------------------
       0      Base Model     794.100    800.067    637.196    0.17680    0.16097 
       1      enzyme_test    766.642    774.598    610.282    0.52292    0.50421 
       2      bcs            746.376    756.320    591.702    0.68413    0.66518 
       3      alc_heavy      730.924    742.858    579.087    0.77136    0.75269 
      --------------------------------------------------------------------------
      
      Final Model Output 
      ------------------
      
                                 Model Summary                            
      -------------------------------------------------------------------
      R                         0.878       RMSE                 188.249 
      R-Squared                 0.771       MSE                35437.709 
      Adj. R-Squared            0.753       Coef. Var             28.147 
      Pred R-Squared            0.695       AIC                  730.924 
      MAE                     140.619       SBC                  742.858 
      -------------------------------------------------------------------
       RMSE: Root Mean Square Error 
       MSE: Mean Square Error 
       MAE: Mean Absolute Error 
       AIC: Akaike Information Criteria 
       SBC: Schwarz Bayesian Criteria 
      
                                       ANOVA                                  
      -----------------------------------------------------------------------
                         Sum of                                              
                        Squares        DF    Mean Square      F         Sig. 
      -----------------------------------------------------------------------
      Regression    6455884.265         4    1613971.066    41.327    0.0000 
      Residual      1913636.272        49      39053.801                     
      Total         8369520.537        53                                    
      -----------------------------------------------------------------------
      
                                            Parameter Estimates                                        
      ------------------------------------------------------------------------------------------------
            model         Beta    Std. Error    Std. Beta      t        Sig         lower       upper 
      ------------------------------------------------------------------------------------------------
      (Intercept)    -1334.424       180.589                 -7.389    0.000    -1697.332    -971.516 
           pindex       10.131         1.622        0.431     6.246    0.000        6.871      13.390 
      enzyme_test       11.243         1.308        0.601     8.596    0.000        8.614      13.871 
              bcs       81.439        17.781        0.329     4.580    0.000       45.706     117.171 
        alc_heavy      312.777        72.341        0.309     4.324    0.000      167.402     458.152 
      ------------------------------------------------------------------------------------------------
      

# output from stepSBIC forward regression is as expected

    Code
      ols_step_forward_sbic(model)
    Output
      
      
                                    Stepwise Summary                              
      --------------------------------------------------------------------------
      Step    Variable         AIC        SBC       SBIC        R2       Adj. R2 
      --------------------------------------------------------------------------
       0      Base Model     802.606    806.584    646.794    0.00000    0.00000 
       1      liver_test     771.875    777.842    616.009    0.45454    0.44405 
       2      alc_heavy      761.439    769.395    605.506    0.56674    0.54975 
       3      enzyme_test    750.509    760.454    595.297    0.65900    0.63854 
       4      pindex         735.715    747.649    582.943    0.75015    0.72975 
       5      bcs            730.620    744.543    579.638    0.78091    0.75808 
      --------------------------------------------------------------------------
      
      Final Model Output 
      ------------------
      
                                 Model Summary                            
      -------------------------------------------------------------------
      R                         0.884       RMSE                 184.276 
      R-Squared                 0.781       MSE                33957.712 
      Adj. R-Squared            0.758       Coef. Var             27.839 
      Pred R-Squared            0.700       AIC                  730.620 
      MAE                     137.656       SBC                  744.543 
      -------------------------------------------------------------------
       RMSE: Root Mean Square Error 
       MSE: Mean Square Error 
       MAE: Mean Absolute Error 
       AIC: Akaike Information Criteria 
       SBC: Schwarz Bayesian Criteria 
      
                                       ANOVA                                  
      -----------------------------------------------------------------------
                         Sum of                                              
                        Squares        DF    Mean Square      F         Sig. 
      -----------------------------------------------------------------------
      Regression    6535804.090         5    1307160.818    34.217    0.0000 
      Residual      1833716.447        48      38202.426                     
      Total         8369520.537        53                                    
      -----------------------------------------------------------------------
      
                                            Parameter Estimates                                        
      ------------------------------------------------------------------------------------------------
            model         Beta    Std. Error    Std. Beta      t        Sig         lower       upper 
      ------------------------------------------------------------------------------------------------
      (Intercept)    -1178.330       208.682                 -5.647    0.000    -1597.914    -758.746 
       liver_test       58.064        40.144        0.156     1.446    0.155      -22.652     138.779 
        alc_heavy      317.848        71.634        0.314     4.437    0.000      173.818     461.878 
      enzyme_test        9.748         1.656        0.521     5.887    0.000        6.419      13.077 
           pindex        8.924         1.808        0.380     4.935    0.000        5.288      12.559 
              bcs       59.864        23.060        0.241     2.596    0.012       13.498     106.230 
      ------------------------------------------------------------------------------------------------
      

---

    Code
      ols_step_forward_sbic(model, progress = TRUE)
    Output
      Forward Selection Method 
      ------------------------
      
      Candidate Terms: 
      
      1. bcs 
      2. pindex 
      3. enzyme_test 
      4. liver_test 
      5. age 
      6. gender 
      7. alc_mod 
      8. alc_heavy 
      
      
      Variables Entered: 
      
      => liver_test 
      => alc_heavy 
      => enzyme_test 
      => pindex 
      => bcs 
      
      No more variables to be added.
      
      
                                    Stepwise Summary                              
      --------------------------------------------------------------------------
      Step    Variable         AIC        SBC       SBIC        R2       Adj. R2 
      --------------------------------------------------------------------------
       0      Base Model     802.606    806.584    646.794    0.00000    0.00000 
       1      liver_test     771.875    777.842    616.009    0.45454    0.44405 
       2      alc_heavy      761.439    769.395    605.506    0.56674    0.54975 
       3      enzyme_test    750.509    760.454    595.297    0.65900    0.63854 
       4      pindex         735.715    747.649    582.943    0.75015    0.72975 
       5      bcs            730.620    744.543    579.638    0.78091    0.75808 
      --------------------------------------------------------------------------
      
      Final Model Output 
      ------------------
      
                                 Model Summary                            
      -------------------------------------------------------------------
      R                         0.884       RMSE                 184.276 
      R-Squared                 0.781       MSE                33957.712 
      Adj. R-Squared            0.758       Coef. Var             27.839 
      Pred R-Squared            0.700       AIC                  730.620 
      MAE                     137.656       SBC                  744.543 
      -------------------------------------------------------------------
       RMSE: Root Mean Square Error 
       MSE: Mean Square Error 
       MAE: Mean Absolute Error 
       AIC: Akaike Information Criteria 
       SBC: Schwarz Bayesian Criteria 
      
                                       ANOVA                                  
      -----------------------------------------------------------------------
                         Sum of                                              
                        Squares        DF    Mean Square      F         Sig. 
      -----------------------------------------------------------------------
      Regression    6535804.090         5    1307160.818    34.217    0.0000 
      Residual      1833716.447        48      38202.426                     
      Total         8369520.537        53                                    
      -----------------------------------------------------------------------
      
                                            Parameter Estimates                                        
      ------------------------------------------------------------------------------------------------
            model         Beta    Std. Error    Std. Beta      t        Sig         lower       upper 
      ------------------------------------------------------------------------------------------------
      (Intercept)    -1178.330       208.682                 -5.647    0.000    -1597.914    -758.746 
       liver_test       58.064        40.144        0.156     1.446    0.155      -22.652     138.779 
        alc_heavy      317.848        71.634        0.314     4.437    0.000      173.818     461.878 
      enzyme_test        9.748         1.656        0.521     5.887    0.000        6.419      13.077 
           pindex        8.924         1.808        0.380     4.935    0.000        5.288      12.559 
              bcs       59.864        23.060        0.241     2.596    0.012       13.498     106.230 
      ------------------------------------------------------------------------------------------------
      

---

    Code
      ols_step_forward_sbic(model, details = TRUE)
    Output
      Forward Selection Method 
      ------------------------
      
      Candidate Terms: 
      
      1. bcs 
      2. pindex 
      3. enzyme_test 
      4. liver_test 
      5. age 
      6. gender 
      7. alc_mod 
      8. alc_heavy 
      
      
      Step     => 0 
      Model    => y ~ 1 
      SBIC     => 649.3977 
      
      Initiating stepwise selection... 
      
                             Table: Adding New Variables                        
      -------------------------------------------------------------------------
      Predictor      DF      AIC        SBC       SBIC        R2       Adj. R2  
      -------------------------------------------------------------------------
      liver_test      1    771.875    777.842    616.009    0.45454     0.44405 
      enzyme_test     1    782.629    788.596    626.220    0.33435     0.32154 
      pindex          1    794.100    800.067    637.196    0.17680     0.16097 
      alc_heavy       1    794.301    800.268    637.389    0.17373     0.15784 
      bcs             1    797.697    803.664    640.655    0.12010     0.10318 
      alc_mod         1    802.828    808.795    645.601    0.03239     0.01378 
      gender          1    802.956    808.923    645.725    0.03009     0.01143 
      age             1    803.834    809.801    646.572    0.01420    -0.00476 
      -------------------------------------------------------------------------
      
      Step     => 1 
      Added    => liver_test 
      Model    => y ~ liver_test 
      SBIC     => 618.7808 
      
                            Table: Adding New Variables                        
      ------------------------------------------------------------------------
      Predictor      DF      AIC        SBC       SBIC        R2       Adj. R2 
      ------------------------------------------------------------------------
      alc_heavy       1    761.439    769.395    605.506    0.56674    0.54975 
      enzyme_test     1    762.077    770.033    606.090    0.56159    0.54440 
      pindex          1    770.387    778.343    613.737    0.48866    0.46861 
      alc_mod         1    771.141    779.097    614.435    0.48147    0.46113 
      gender          1    773.802    781.758    616.901    0.45528    0.43391 
      age             1    773.831    781.787    616.928    0.45498    0.43361 
      bcs             1    773.867    781.823    616.961    0.45462    0.43323 
      ------------------------------------------------------------------------
      
      Step     => 2 
      Added    => alc_heavy 
      Model    => y ~ liver_test + alc_heavy 
      SBIC     => 608.54 
      
                            Table: Adding New Variables                        
      ------------------------------------------------------------------------
      Predictor      DF      AIC        SBC       SBIC        R2       Adj. R2 
      ------------------------------------------------------------------------
      enzyme_test     1    750.509    760.454    595.297    0.65900    0.63854 
      pindex          1    756.125    766.070    600.225    0.62163    0.59892 
      bcs             1    763.063    773.008    606.379    0.56975    0.54394 
      age             1    763.110    773.055    606.421    0.56938    0.54354 
      alc_mod         1    763.428    773.373    606.704    0.56683    0.54084 
      gender          1    763.433    773.378    606.709    0.56679    0.54080 
      ------------------------------------------------------------------------
      
      Step     => 3 
      Added    => enzyme_test 
      Model    => y ~ liver_test + alc_heavy + enzyme_test 
      SBIC     => 597.8907 
      
                           Table: Adding New Variables                       
      ----------------------------------------------------------------------
      Predictor    DF      AIC        SBC       SBIC        R2       Adj. R2 
      ----------------------------------------------------------------------
      pindex        1    735.715    747.649    582.943    0.75015    0.72975 
      bcs           1    750.782    762.716    595.377    0.66973    0.64277 
      alc_mod       1    752.403    764.337    596.743    0.65967    0.63189 
      age           1    752.416    764.350    596.755    0.65959    0.63180 
      gender        1    752.509    764.443    596.833    0.65900    0.63116 
      ----------------------------------------------------------------------
      
      Step     => 4 
      Added    => pindex 
      Model    => y ~ liver_test + alc_heavy + enzyme_test + pindex 
      SBIC     => 583.4688 
      
                           Table: Adding New Variables                       
      ----------------------------------------------------------------------
      Predictor    DF      AIC        SBC       SBIC        R2       Adj. R2 
      ----------------------------------------------------------------------
      bcs           1    730.620    744.543    579.638    0.78091    0.75808 
      age           1    737.680    751.603    585.012    0.75030    0.72429 
      gender        1    737.712    751.635    585.036    0.75016    0.72413 
      alc_mod       1    737.713    751.636    585.037    0.75015    0.72413 
      ----------------------------------------------------------------------
      
      Step     => 5 
      Added    => bcs 
      Model    => y ~ liver_test + alc_heavy + enzyme_test + pindex + bcs 
      SBIC     => 578.8438 
      
                           Table: Adding New Variables                       
      ----------------------------------------------------------------------
      Predictor    DF      AIC        SBC       SBIC        R2       Adj. R2 
      ----------------------------------------------------------------------
      age           1    732.494    748.406    581.938    0.78142    0.75351 
      gender        1    732.551    748.463    581.978    0.78119    0.75325 
      alc_mod       1    732.614    748.526    582.023    0.78093    0.75297 
      ----------------------------------------------------------------------
      
      
      No more variables to be added.
      
      Variables Selected: 
      
      => liver_test 
      => alc_heavy 
      => enzyme_test 
      => pindex 
      => bcs 
      
      
                                    Stepwise Summary                              
      --------------------------------------------------------------------------
      Step    Variable         AIC        SBC       SBIC        R2       Adj. R2 
      --------------------------------------------------------------------------
       0      Base Model     802.606    806.584    646.794    0.00000    0.00000 
       1      liver_test     771.875    777.842    616.009    0.45454    0.44405 
       2      alc_heavy      761.439    769.395    605.506    0.56674    0.54975 
       3      enzyme_test    750.509    760.454    595.297    0.65900    0.63854 
       4      pindex         735.715    747.649    582.943    0.75015    0.72975 
       5      bcs            730.620    744.543    579.638    0.78091    0.75808 
      --------------------------------------------------------------------------
      
      Final Model Output 
      ------------------
      
                                 Model Summary                            
      -------------------------------------------------------------------
      R                         0.884       RMSE                 184.276 
      R-Squared                 0.781       MSE                33957.712 
      Adj. R-Squared            0.758       Coef. Var             27.839 
      Pred R-Squared            0.700       AIC                  730.620 
      MAE                     137.656       SBC                  744.543 
      -------------------------------------------------------------------
       RMSE: Root Mean Square Error 
       MSE: Mean Square Error 
       MAE: Mean Absolute Error 
       AIC: Akaike Information Criteria 
       SBC: Schwarz Bayesian Criteria 
      
                                       ANOVA                                  
      -----------------------------------------------------------------------
                         Sum of                                              
                        Squares        DF    Mean Square      F         Sig. 
      -----------------------------------------------------------------------
      Regression    6535804.090         5    1307160.818    34.217    0.0000 
      Residual      1833716.447        48      38202.426                     
      Total         8369520.537        53                                    
      -----------------------------------------------------------------------
      
                                            Parameter Estimates                                        
      ------------------------------------------------------------------------------------------------
            model         Beta    Std. Error    Std. Beta      t        Sig         lower       upper 
      ------------------------------------------------------------------------------------------------
      (Intercept)    -1178.330       208.682                 -5.647    0.000    -1597.914    -758.746 
       liver_test       58.064        40.144        0.156     1.446    0.155      -22.652     138.779 
        alc_heavy      317.848        71.634        0.314     4.437    0.000      173.818     461.878 
      enzyme_test        9.748         1.656        0.521     5.887    0.000        6.419      13.077 
           pindex        8.924         1.808        0.380     4.935    0.000        5.288      12.559 
              bcs       59.864        23.060        0.241     2.596    0.012       13.498     106.230 
      ------------------------------------------------------------------------------------------------
      

---

    Code
      ols_step_forward_sbic(model, include = "pindex", details = TRUE)
    Output
      Forward Selection Method 
      ------------------------
      
      Candidate Terms: 
      
      1. bcs 
      2. enzyme_test 
      3. liver_test 
      4. age 
      5. gender 
      6. alc_mod 
      7. alc_heavy 
      
      
      Step     => 0 
      Model    => y ~ pindex 
      SBIC     => 641.0052 
      
      Initiating stepwise selection... 
      
                            Table: Adding New Variables                        
      ------------------------------------------------------------------------
      Predictor      DF      AIC        SBC       SBIC        R2       Adj. R2 
      ------------------------------------------------------------------------
      enzyme_test     1    766.642    774.598    610.282    0.52292    0.50421 
      liver_test      1    770.387    778.343    613.737    0.48866    0.46861 
      alc_heavy       1    780.568    788.524    623.203    0.38256    0.35835 
      bcs             1    789.400    797.356    631.496    0.27285    0.24434 
      alc_mod         1    792.349    800.305    634.280    0.23204    0.20192 
      gender          1    795.111    803.067    636.895    0.19174    0.16004 
      age             1    795.450    803.406    637.216    0.18665    0.15476 
      ------------------------------------------------------------------------
      
      Step     => 1 
      Added    => enzyme_test 
      Model    => y ~ pindex + enzyme_test 
      SBIC     => 613.7429 
      
                            Table: Adding New Variables                       
      -----------------------------------------------------------------------
      Predictor     DF      AIC        SBC       SBIC        R2       Adj. R2 
      -----------------------------------------------------------------------
      bcs            1    746.376    756.320    591.702    0.68413    0.66518 
      alc_heavy      1    748.167    758.112    593.257    0.67347    0.65388 
      liver_test     1    755.099    765.044    599.321    0.62875    0.60647 
      alc_mod        1    764.533    774.477    607.692    0.55788    0.53135 
      age            1    767.697    777.642    610.529    0.53120    0.50307 
      gender         1    768.479    778.424    611.232    0.52436    0.49582 
      -----------------------------------------------------------------------
      
      Step     => 2 
      Added    => bcs 
      Model    => y ~ pindex + enzyme_test + bcs 
      SBIC     => 593.7573 
      
                            Table: Adding New Variables                       
      -----------------------------------------------------------------------
      Predictor     DF      AIC        SBC       SBIC        R2       Adj. R2 
      -----------------------------------------------------------------------
      alc_heavy      1    730.924    742.858    579.087    0.77136    0.75269 
      alc_mod        1    744.985    756.919    590.537    0.70335    0.67913 
      age            1    747.171    759.105    592.354    0.69109    0.66588 
      liver_test     1    747.181    759.114    592.362    0.69104    0.66582 
      gender         1    748.330    760.264    593.322    0.68439    0.65863 
      -----------------------------------------------------------------------
      
      Step     => 3 
      Added    => alc_heavy 
      Model    => y ~ pindex + enzyme_test + bcs + alc_heavy 
      SBIC     => 578.6783 
      
                            Table: Adding New Variables                       
      -----------------------------------------------------------------------
      Predictor     DF      AIC        SBC       SBIC        R2       Adj. R2 
      -----------------------------------------------------------------------
      liver_test     1    730.620    744.543    579.638    0.78091    0.75808 
      age            1    732.339    746.262    580.934    0.77382    0.75026 
      gender         1    732.516    746.439    581.067    0.77308    0.74944 
      alc_mod        1    732.909    746.832    581.365    0.77142    0.74761 
      -----------------------------------------------------------------------
      
      
      No more variables to be added.
      
      Variables Selected: 
      
      => pindex 
      => enzyme_test 
      => bcs 
      => alc_heavy 
      
      
                                    Stepwise Summary                              
      --------------------------------------------------------------------------
      Step    Variable         AIC        SBC       SBIC        R2       Adj. R2 
      --------------------------------------------------------------------------
       0      Base Model     794.100    800.067    637.196    0.17680    0.16097 
       1      enzyme_test    766.642    774.598    610.282    0.52292    0.50421 
       2      bcs            746.376    756.320    591.702    0.68413    0.66518 
       3      alc_heavy      730.924    742.858    579.087    0.77136    0.75269 
      --------------------------------------------------------------------------
      
      Final Model Output 
      ------------------
      
                                 Model Summary                            
      -------------------------------------------------------------------
      R                         0.878       RMSE                 188.249 
      R-Squared                 0.771       MSE                35437.709 
      Adj. R-Squared            0.753       Coef. Var             28.147 
      Pred R-Squared            0.695       AIC                  730.924 
      MAE                     140.619       SBC                  742.858 
      -------------------------------------------------------------------
       RMSE: Root Mean Square Error 
       MSE: Mean Square Error 
       MAE: Mean Absolute Error 
       AIC: Akaike Information Criteria 
       SBC: Schwarz Bayesian Criteria 
      
                                       ANOVA                                  
      -----------------------------------------------------------------------
                         Sum of                                              
                        Squares        DF    Mean Square      F         Sig. 
      -----------------------------------------------------------------------
      Regression    6455884.265         4    1613971.066    41.327    0.0000 
      Residual      1913636.272        49      39053.801                     
      Total         8369520.537        53                                    
      -----------------------------------------------------------------------
      
                                            Parameter Estimates                                        
      ------------------------------------------------------------------------------------------------
            model         Beta    Std. Error    Std. Beta      t        Sig         lower       upper 
      ------------------------------------------------------------------------------------------------
      (Intercept)    -1334.424       180.589                 -7.389    0.000    -1697.332    -971.516 
           pindex       10.131         1.622        0.431     6.246    0.000        6.871      13.390 
      enzyme_test       11.243         1.308        0.601     8.596    0.000        8.614      13.871 
              bcs       81.439        17.781        0.329     4.580    0.000       45.706     117.171 
        alc_heavy      312.777        72.341        0.309     4.324    0.000      167.402     458.152 
      ------------------------------------------------------------------------------------------------
      

