% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ctcisQTL.R
\name{ctcisQTL}
\alias{ctcisQTL}
\title{Cell-Type-Specific QTL analysis}
\usage{
ctcisQTL(
  X,
  Xpos,
  W,
  Y,
  Ypos,
  C = NULL,
  max.pos.diff = 1e+06,
  outdir = tempdir(),
  outfile = "ctcisQTL.out.txt"
)
}
\arguments{
\item{X}{Matrix (or vector) of SNP genotypes; SNPs x samples.}

\item{Xpos}{Vector of the physical position of X}

\item{W}{Matrix of cell type composition; samples x cell types.}

\item{Y}{Matrix (or vector) of bulk omics measurements; markers x samples.}

\item{Ypos}{Vector of the physical position of Y}

\item{C}{Matrix (or vector) of covariates; samples x covariates.
X, Xpos, W, Y, Ypos, C should be numeric.}

\item{max.pos.diff}{Maximum positional difference to compute cis-QTL.
Association analysis is performed between a row of X and a row of Y,
only when they are within this limit.
Since the limiting is only by position, the function needs to be run
separately for each chromosome.}

\item{outdir}{Output directory.}

\item{outfile}{Output file.}
}
\value{
The estimate, statistic, p.value are written to the specified file.
}
\description{
Cell-Type-Specific QTL analysis
}
\details{
A function for analyses of QTL, such as eQTL, mQTL, pQTL.
The statistical test is almost identical to
\code{ctassoc(test =  "nls.identity", regularize = "TRUE")}.
Association analysis is performed between each row of Y and each row of X.
Usually, the former will be a methylation/expression marker,
and the latter will be a SNP.
To cope with the large number of combinations,
the testing is limited to pairs whose position is within
the difference specified by \code{max.pos.diff}; i.e., limited to cis-QTL.
In detail, this function performs linear ridge regression,
whereas \code{ctassoc(test =  "nls.identity", regularize = "TRUE")}
actually is nonlinear regression
but with \eqn{f} = identity as normalizing transformation.
In order to speed up computation, first, the parameters \eqn{\alpha_{h j}} and
\eqn{\gamma_{j l}} are fit by ordinary linear regression assuming \eqn{\beta_{h j k} = 0}.
Next, \eqn{\beta_{h j k}} are fit and tested by
linear ridge regression (see documentation for \link[omicwas]{ctassoc}).
}
\examples{
\donttest{
data(GSE79262small)
X    = GSE79262small$X
Xpos = GSE79262small$Xpos
W    = GSE79262small$W
Y    = GSE79262small$Y
Ypos = GSE79262small$Ypos
C    = GSE79262small$C
X    = X[seq(1, 3601, 100), ] # for brevity
Xpos = Xpos[seq(1, 3601, 100)]
ctcisQTL(X, Xpos, W, Y, Ypos, C = C)
}

}
\seealso{
ctassoc
}
