% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{onetime_mark_as_done}
\alias{onetime_mark_as_done}
\title{Mark an action as done}
\usage{
onetime_mark_as_done(
  id = deprecate_calling_package(),
  path = default_lockfile_dir()
)
}
\arguments{
\item{id}{Unique ID string. If this is unset, the name of the calling
package will be used. Since onetime 0.2.0, not setting \code{id} is
deprecated.}

\item{path}{Directory to store lockfiles. The default uses a unique
directory corresponding to the calling package, beneath
\code{\link[rappdirs:user_data_dir]{rappdirs::user_config_dir()}}. Normally you should leave this as the
default.}
}
\value{
Invisible \code{TRUE} if the action represented
by \code{id} had not been done before, and has now been explicitly marked as done.
Invisible \code{FALSE} if it was already marked as done (and still is).
}
\description{
This manually marks an action as done.
}
\details{
Note that no \code{expiry} parameter is available, because \code{expiry} is
backward-looking. See \code{\link[=onetime_do]{onetime_do()}} for more information.

Marking an action done requires permission to store files on the user's
computer, just like other onetime actions.
}
\examples{
oo <- options(onetime.dir = tempdir(check = TRUE))
id <- sample(10000L, 1)
onetime_mark_as_done(id = id)
onetime_message("Won't be shown", id = id)

onetime_reset(id = id)
options(oo)
}
