% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Viz_manipul_main.R
\name{export_cytoscape}
\alias{export_cytoscape}
\title{Export to Cytoscape format}
\usage{
export_cytoscape(
  ontology,
  annotations = "auto",
  is_a = c("is_a"),
  part_of = c("BFO:0000050")
)
}
\arguments{
\item{ontology}{Ontology}

\item{annotations}{which annotations to use: "auto" means automatic annotations, "manual" means manual ones.
Alternatively, any other list containing annotations can be specified.}

\item{is_a}{is_a}

\item{part_of}{part_of}
}
\value{
Returns a table
}
\description{
This function converts character annotations to Cytoscape format. It returns a table that can be saved as in csv format
and imported in Cytoscape. In Cytoscape choose File -> Import -> Network -> File. Then assign columns to nodes and edges. Do not select
columns that enumerate the tables' rows!
}
\examples{
\donttest{
data(HAO)
data(Sharkey_2011)
data(Sharkey_2011_annot)
ontology<-HAO
# processing ontology to incorporate character statements
ontology<-onto_process(ontology, Sharkey_2011[,1], do.annot = F)
# embedding manual annotations
ontology$annot_characters<-Sharkey_2011_annot
# exporting
cyto<-export_cytoscape(ontology, annotations = ontology$annot_characters,
is_a = c("is_a"), part_of = c("BFO:0000050"))
#write.csv(cyto, file="cyto.csv")
}
}
