% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Viz_manipul_main.R
\name{list2edges}
\alias{list2edges}
\title{Convert list to edge matrix}
\usage{
list2edges(annotated.char.list, col_order_inverse = FALSE)
}
\arguments{
\item{annotated.char.list}{Character list with ontology annotations.}

\item{col_order_inverse}{The default creates the first columns consisting if character IDs and the second columns consisting of ontology annatotaions.
The inverse order changes the columns order.}
}
\value{
Two-column matrix.
}
\description{
Takes a list of character annotations and creates an edge matrix comprising two columns: from and to.
The list to table conversion can be done using ldply function from plyr package: plyr::ldply(list, rbind).
}
\examples{
annot_list<-list(`CHAR:1`=c("HAO:0000933", "HAO:0000958"), `CHAR:2`=c("HAO:0000833", "HAO:0000258"))
list2edges(annot_list)
# use plyr package and run
plyr::ldply(annot_list, rbind)
}
